/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.numerical.Endianess;
import org.refcodes.properties.Properties;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.serial.AllocSegmentHead;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.PropertiesSection;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.TransmissionSequenceException;

public class PropertiesSectionTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testPropertiesSegment() throws IOException, TransmissionSequenceException {
        PropertiesBuilderImpl theBuilder = new PropertiesBuilderImpl();
        theBuilder.put((Object)"/sensor/0/name", (Object)"temp01");
        theBuilder.putFloat("/sensor/0/value", Float.valueOf(12.37f));
        theBuilder.put((Object)"/sensor/1/name", (Object)"temp01");
        theBuilder.putFloat("/sensor/1/value", Float.valueOf(8.71f));
        for (int eLengthWidth = 2; eLengthWidth <= 8; ++eLengthWidth) {
            for (Endianess eEndianess : Endianess.values()) {
                if (IS_LOG_TESTS) {
                    System.out.println("---------- Length width = <" + eLengthWidth + ">, endianess = <" + eEndianess + "> ----------");
                }
                Segment[] segmentArray = new Segment[4];
                AllocSegmentHead theLen = SerialSugar.allocSegmentHead((int)eLengthWidth, (Endianess)eEndianess);
                segmentArray[0] = theLen;
                segmentArray[1] = SerialSugar.booleanSegment((boolean)true);
                segmentArray[2] = SerialSugar.intSegment((Integer)5161);
                segmentArray[3] = (Segment)theLen.letBody((Object)SerialSugar.allocSegmentBody((Section)new PropertiesSection((Properties)theBuilder)));
                CrcSegmentDecorator theSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
                Sequence theSequence = theSegment.toSequence();
                if (IS_LOG_TESTS) {
                    System.out.println("Sequence (hex) = " + theSequence.toHexString());
                    System.out.println("Transmission = " + theSegment.toString());
                    System.out.println("AbstractSchema = " + theSegment.toSchema());
                }
                Segment[] segmentArray2 = new Segment[4];
                AllocSegmentHead theOtherLen = SerialSugar.allocSegmentHead((int)eLengthWidth, (Endianess)eEndianess);
                segmentArray2[0] = theOtherLen;
                segmentArray2[1] = SerialSugar.booleanSegment();
                segmentArray2[2] = SerialSugar.intSegment();
                segmentArray2[3] = (Segment)theOtherLen.letBody((Object)SerialSugar.allocSegmentBody((Section)new PropertiesSection()));
                CrcSegmentDecorator theOtherSegment = SerialSugar.crcPrefixSegment((Segment)SerialSugar.segmentComposite((Segment[])segmentArray2), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
                theOtherSegment.fromTransmission(theSequence);
                Assertions.assertEquals((Object)theOtherSegment, (Object)theOtherSegment);
                if (!IS_LOG_TESTS) continue;
                System.out.println("Other segment = " + theOtherSegment.toString());
                System.out.println("Other schema = " + theOtherSegment.toSchema());
            }
        }
    }
}

