/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.serial.AbstractLoopbackPortTest;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.BreakerSegmentDecorator;
import org.refcodes.serial.ComplexTypeSegment;
import org.refcodes.serial.FlowControlTimeoutException;
import org.refcodes.serial.Port;
import org.refcodes.serial.ReadyToReceiveSegmentDecorator;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentResult;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.SerialTransceiver;
import org.refcodes.serial.StringArraySection;
import org.refcodes.serial.TestFixures;
import org.refcodes.textual.VerboseTextBuilder;

public class ReadyToReceiveTest
extends AbstractLoopbackPortTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final int LOOPS = 3;

    @Test
    public void testReadyToReceiveSegmentDecorator1() throws IOException, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            TestFixures.WeatherData theSenderData = TestFixures.createWeatherData();
            ReadyToReceiveSegmentDecorator theSenderSeg = SerialSugar.readyToReceiveSegment((Segment)SerialSugar.stopAndWaitSegment((Segment)SerialSugar.crcPrefixSegment((Segment)SerialSugar.complexTypeSegment((Object)theSenderData), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE)));
            ComplexTypeSegment theReceiverSegment = SerialSugar.complexTypeSegment(TestFixures.WeatherData.class);
            ReadyToReceiveSegmentDecorator theReceiverSeg = SerialSugar.readyToReceiveSegment((Segment)SerialSugar.stopAndWaitSegment((Segment)SerialSugar.crcPrefixSegment((Segment)theReceiverSegment, (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE)));
            for (int i = 0; i < 3; ++i) {
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                theResult.waitForResult();
                TestFixures.WeatherData theReceiverData = (TestFixures.WeatherData)theReceiverSegment.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(theReceiverData);
                }
                Assertions.assertEquals((Object)theSenderData, (Object)theReceiverData);
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testReadyToReceiveSegmentDecorator1Breaker() throws IOException, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            TestFixures.WeatherData theSenderData = TestFixures.createWeatherData();
            ReadyToReceiveSegmentDecorator theSenderSeg = SerialSugar.readyToReceiveSegment((Segment)SerialSugar.stopAndWaitSegment((Segment)SerialSugar.crcPrefixSegment((Segment)SerialSugar.complexTypeSegment((Object)theSenderData), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE)));
            ComplexTypeSegment theReceiverSegment = SerialSugar.complexTypeSegment(TestFixures.WeatherData.class);
            BreakerSegmentDecorator theBreaker = SerialSugar.breakerSegment((Segment)SerialSugar.crcPrefixSegment((Segment)theReceiverSegment, (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE), (int)3);
            ReadyToReceiveSegmentDecorator theReceiverSeg = SerialSugar.readyToReceiveSegment((Segment)SerialSugar.stopAndWaitSegment((Segment)theBreaker));
            for (int i = 0; i < 3; ++i) {
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                theResult.waitForResult();
                TestFixures.WeatherData theReceiverData = (TestFixures.WeatherData)theReceiverSegment.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(theReceiverData);
                }
                Assertions.assertEquals((Object)theSenderData, (Object)theReceiverData);
                theBreaker.reset();
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testReadyToReceiveSegmentDecorator2() throws IOException, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            TestFixures.WeatherData theSenderData = TestFixures.createWeatherData();
            ReadyToReceiveSegmentDecorator theSenderSeg = SerialSugar.readyToReceiveSegment((Segment)SerialSugar.stopAndWaitPacketStreamSegmentBuilder().withDecoratee((Segment)SerialSugar.crcPrefixSegment((Segment)SerialSugar.complexTypeSegment((Object)theSenderData), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE)).withBlockSize(16).build());
            ComplexTypeSegment theReceiverSegment = SerialSugar.complexTypeSegment(TestFixures.WeatherData.class);
            ReadyToReceiveSegmentDecorator theReceiverSeg = SerialSugar.readyToReceiveSegment((Segment)SerialSugar.stopAndWaitPacketStreamSegmentBuilder().withDecoratee((Segment)SerialSugar.crcPrefixSegment((Segment)theReceiverSegment, (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE)).withBlockSize(16).build());
            for (int i = 0; i < 3; ++i) {
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                theResult.waitForResult();
                TestFixures.WeatherData theReceiverData = (TestFixures.WeatherData)theReceiverSegment.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(theReceiverData);
                }
                Assertions.assertEquals((Object)theSenderData, (Object)theReceiverData);
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testReadyToReceiveSegmentDecorator3() throws IOException, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            TestFixures.WeatherData theSenderData = TestFixures.createWeatherData();
            ReadyToReceiveSegmentDecorator theSenderSeg = SerialSugar.readyToReceiveSegment((Segment)SerialSugar.stopAndWaitSegment((Segment)SerialSugar.crcPrefixSegment((Segment)SerialSugar.complexTypeSegment((Object)theSenderData), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE)), (long)500L);
            ComplexTypeSegment theReceiverSegment = SerialSugar.complexTypeSegment(TestFixures.WeatherData.class);
            ReadyToReceiveSegmentDecorator theReceiverSeg = SerialSugar.readyToReceiveSegment((Segment)SerialSugar.stopAndWaitSegment((Segment)SerialSugar.crcPrefixSegment((Segment)theReceiverSegment, (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE)), (int)1, (long)500L);
            for (int i = 0; i < 3; ++i) {
                SegmentResult theResult = theTransmitPort.doTransmitSegment((Segment)theSenderSeg);
                Thread.sleep(400L);
                theReceiverPort.receiveSegment((Segment)theReceiverSeg);
                TestFixures.WeatherData theReceiverData = (TestFixures.WeatherData)theReceiverSegment.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(theReceiverData);
                }
                theResult.waitForResult();
                Assertions.assertEquals((Object)theSenderData, (Object)theReceiverData);
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testReadyToReceiveSegmentDecorator4() throws IOException, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            TestFixures.WeatherData theSenderData = TestFixures.createWeatherData();
            ReadyToReceiveSegmentDecorator theSenderSeg = SerialSugar.readyToReceiveSegment((Segment)SerialSugar.crcPrefixSegment((Segment)SerialSugar.complexTypeSegment((Object)theSenderData), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE), (long)500L);
            ReadyToReceiveSegmentDecorator theReceiverSeg = SerialSugar.readyToReceiveSegment((Segment)SerialSugar.crcPrefixSegment((Segment)SerialSugar.complexTypeSegment(TestFixures.WeatherData.class), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE), (int)1, (long)500L);
            for (int i = 0; i < 3; ++i) {
                SegmentResult theResult;
                block5: {
                    theResult = theTransmitPort.doTransmitSegment((Segment)theSenderSeg);
                    Thread.sleep(600L);
                    try {
                        theReceiverPort.receiveSegment((Segment)theReceiverSeg);
                        Assertions.fail((String)("Expected a <" + FlowControlTimeoutException.class.getSimpleName() + ">!"));
                    }
                    catch (FlowControlTimeoutException e) {
                        if (!IS_LOG_TESTS) break block5;
                        System.out.println(e.getMessage());
                    }
                }
                theResult.waitForResult();
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testReadyToReceiveSegmentDecorator5() throws IOException, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            Object[] theSenderData = new String[]{"This", "is", "not", "a", "love", "song"};
            AllocSectionDecoratorSegment theSenderSeg = SerialSugar.allocSegment((Section)SerialSugar.readyToReceiveSection((Section)SerialSugar.crcPrefixSection((Section)SerialSugar.stringArraySection((String[])theSenderData), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE)));
            StringArraySection theReceiverSection = SerialSugar.stringArraySection();
            AllocSectionDecoratorSegment theReceiverSeg = SerialSugar.allocSegment((Section)SerialSugar.readyToReceiveSection((Section)SerialSugar.crcPrefixSection((Section)theReceiverSection, (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE)));
            for (int i = 0; i < 3; ++i) {
                theReceiverSection.setPayload(null);
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                theResult.waitForResult();
                Object[] theReceiverData = theReceiverSection.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(VerboseTextBuilder.asString((String[])theReceiverData));
                }
                Assertions.assertArrayEquals((Object[])theSenderData, (Object[])theReceiverData);
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }
}

