/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.textual.VerboseTextBuilder;

public class SequenceTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testConstruct() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 }, { 97, 98, 99 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testOutputStream1() throws IOException {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theValues = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteArraySequence theSequence = new ByteArraySequence();
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        OutputStream theOutputStream = theSequence.getOutputStream();
        for (int i = 0; i < theValues.length; ++i) {
            theOutputStream.write(theValues[i]);
        }
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        Assertions.assertArrayEquals((byte[])theValues, (byte[])theSequence.toBytes());
    }

    @Test
    public void testOutputStream2() throws IOException {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theValues = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteArraySequence theSequence = new ByteArraySequence();
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        OutputStream theOutputStream = theSequence.getOutputStream();
        theOutputStream.write(theValues);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        Assertions.assertArrayEquals((byte[])theValues, (byte[])theSequence.toBytes());
    }

    @Test
    public void testInputStream1() throws IOException {
        int eRead;
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        InputStream theInputStream = theSequence.getInputStream();
        int i = 0;
        byte[] theBytes = theSequence.toBytes();
        byte[] theStreamBytes = new byte[theSequence.getLength()];
        while ((eRead = theInputStream.read()) != -1) {
            theStreamBytes[i] = (byte)eRead;
            ++i;
        }
        if (IS_LOG_TESTS) {
            System.out.println(VerboseTextBuilder.asString((byte[])theStreamBytes));
        }
        Assertions.assertArrayEquals((byte[])theBytes, (byte[])theStreamBytes);
    }

    @Test
    public void testInputStream2() throws IOException {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        InputStream theInputStream = theSequence.getInputStream();
        byte[] theBytes = theSequence.toBytes();
        byte[] theStreamBytes = new byte[theSequence.getLength()];
        theInputStream.read(theStreamBytes, 0, theInputStream.available());
        if (IS_LOG_TESTS) {
            System.out.println(VerboseTextBuilder.asString((byte[])theStreamBytes));
        }
        Assertions.assertArrayEquals((byte[])theBytes, (byte[])theStreamBytes);
    }

    @Test
    public void testInputStream3() throws IOException {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        InputStream theInputStream = theSequence.getInputStream();
        byte[] theBytes = theSequence.toBytes(0, 10);
        byte[] theStreamBytes = new byte[10];
        int theRead = theInputStream.read(theStreamBytes, 0, 10);
        if (IS_LOG_TESTS) {
            System.out.println(VerboseTextBuilder.asString((byte[])theStreamBytes));
        }
        Assertions.assertArrayEquals((byte[])theBytes, (byte[])theStreamBytes);
        Assertions.assertEquals((int)theRead, (int)10);
    }

    @Test
    public void testInputStream4() throws IOException {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        InputStream theInputStream = theSequence.getInputStream();
        byte[] theBytes = theSequence.toBytes();
        byte[] theStreamBytes = new byte[theSequence.getLength()];
        int theRead = theInputStream.read(theStreamBytes, 0, 20);
        if (IS_LOG_TESTS) {
            System.out.println(VerboseTextBuilder.asString((byte[])theStreamBytes));
        }
        Assertions.assertArrayEquals((byte[])theBytes, (byte[])theStreamBytes);
        Assertions.assertEquals((int)theRead, (int)theBytes.length);
    }

    @Test
    public void testAppend() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence();
        theSequence.append(theNumbers);
        theSequence.append(theChars);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 }, { 97, 98, 99 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testPrepend() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence(theNumbers);
        theSequence.prepend(theChars);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 97, 98, 99 }, { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testToTruncateTail() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        ByteArraySequence theTruncated = theSequence.toTruncateTail(1);
        if (IS_LOG_TESTS) {
            this.printSequence(theTruncated);
        }
        String theExpected = "{ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 }, { 97, 98 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theTruncated.getChunks()));
        theExpected = "{ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 }, { 97, 98, 99 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testToTruncateHead() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        ByteArraySequence theTruncated = theSequence.toTruncateHead(1);
        if (IS_LOG_TESTS) {
            this.printSequence(theTruncated);
        }
        String theExpected = "{ { 1, 2, 3, 4, 5, 6, 7, 8, 9 }, { 97, 98, 99 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theTruncated.getChunks()));
        theExpected = "{ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 }, { 97, 98, 99 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testTruncateTail1() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.truncateTail(1);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 }, { 97, 98 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testTruncateTail2() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.truncateTail(2);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 }, { 97 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testTruncateTail3() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.truncateTail(3);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testTruncateTail4() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.truncateTail(4);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 0, 1, 2, 3, 4, 5, 6, 7, 8 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testTruncateTail5() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.truncateTail(13);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{}";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testTruncateTail6() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.truncateTail(14);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{}";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testTruncateHead1() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.truncateHead(1);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 1, 2, 3, 4, 5, 6, 7, 8, 9 }, { 97, 98, 99 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testTruncateHead2() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.truncateHead(9);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 9 }, { 97, 98, 99 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testTruncateHead3() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.truncateHead(10);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 97, 98, 99 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testTruncateHead4() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.truncateHead(11);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 98, 99 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testTruncateHead5() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.truncateHead(13);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{}";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testTruncateHead6() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] theChars = new byte[]{97, 98, 99};
        ByteArraySequence theSequence = new ByteArraySequence((byte[][])new byte[][]{theNumbers, theChars});
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.truncateHead(14);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{}";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testWrite1() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteArraySequence theSequence = new ByteArraySequence();
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.overwrite(1, theNumbers);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testWrite2() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theChars = new byte[]{97, 98, 99};
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteArraySequence theSequence = new ByteArraySequence(theChars);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.overwrite(1, theNumbers);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 97, 0, 1 }, { 2, 3, 4, 5, 6, 7, 8, 9 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    @Test
    public void testWrite3() {
        if (IS_LOG_TESTS) {
            System.out.println("### " + RuntimeUtility.getCallerStackTraceElement().getMethodName() + " ###\n");
        }
        byte[] theChars = new byte[]{97, 98, 99};
        byte[] theNumbers = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteArraySequence theSequence = new ByteArraySequence(theChars);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        theSequence.overwrite(5, theNumbers);
        if (IS_LOG_TESTS) {
            this.printSequence(theSequence);
        }
        String theExpected = "{ { 97, 98, 99 }, { 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 } }";
        Assertions.assertEquals((Object)theExpected, (Object)VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
    }

    private void printSequence(ByteArraySequence theSequence) {
        System.out.println(theSequence.toString());
        System.out.println(VerboseTextBuilder.asString((Object[])theSequence.getChunks()));
        System.out.println();
    }
}

