/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.serial.AbstractLoopbackPortTest;
import org.refcodes.serial.BreakerSectionDecorator;
import org.refcodes.serial.BreakerSegmentDecorator;
import org.refcodes.serial.ComplexTypeSegment;
import org.refcodes.serial.CrcSegmentDecorator;
import org.refcodes.serial.NoSuchPortExcpetion;
import org.refcodes.serial.Port;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentResult;
import org.refcodes.serial.SerialSugar;
import org.refcodes.serial.SerialTransceiver;
import org.refcodes.serial.StopAndWaitSegmentDecorator;
import org.refcodes.serial.StringSection;
import org.refcodes.serial.TestFixures;
import org.refcodes.serial.TransmissionSequenceException;

public class StopAndWaitTest
extends AbstractLoopbackPortTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final int LOOPS = 3;

    @Test
    public void testStopAndWaitSegmentDecorator1() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            TestFixures.WeatherData theSenderData = TestFixures.createWeatherData();
            StopAndWaitSegmentDecorator theSenderSeg = SerialSugar.stopAndWaitSegment((Segment)SerialSugar.crcPrefixSegment((Segment)SerialSugar.complexTypeSegment((Object)theSenderData), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE));
            ComplexTypeSegment theReceiverComplexSegment = SerialSugar.complexTypeSegment(TestFixures.WeatherData.class);
            StopAndWaitSegmentDecorator theReceiverSeg = SerialSugar.stopAndWaitSegment((Segment)SerialSugar.crcPrefixSegment((Segment)theReceiverComplexSegment, (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE));
            for (int i = 0; i < 3; ++i) {
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                theResult.waitForResult();
                TestFixures.WeatherData theReceiverData = (TestFixures.WeatherData)theReceiverComplexSegment.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(theReceiverData);
                }
                Assertions.assertEquals((Object)theSenderData, (Object)theReceiverData);
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testStopAndWaitSegmentDecorator2() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            TestFixures.WeatherData theSenderData = TestFixures.createWeatherData();
            StopAndWaitSegmentDecorator theSenderSeg = SerialSugar.stopAndWaitSegment((Segment)SerialSugar.crcPrefixSegment((Segment)SerialSugar.complexTypeSegment((Object)theSenderData), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE));
            ComplexTypeSegment theReceiverComplexSegment = SerialSugar.complexTypeSegment(TestFixures.WeatherData.class);
            BreakerSegmentDecorator theBreaker = SerialSugar.breakerSegment((Segment)SerialSugar.crcPrefixSegment((Segment)theReceiverComplexSegment, (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE), (int)3);
            StopAndWaitSegmentDecorator theReceiverSeg = SerialSugar.stopAndWaitSegment((Segment)theBreaker);
            for (int i = 0; i < 3; ++i) {
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                theResult.waitForResult();
                TestFixures.WeatherData theReceiverData = (TestFixures.WeatherData)theReceiverComplexSegment.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(theReceiverData);
                }
                Assertions.assertEquals((Object)theSenderData, (Object)theReceiverData);
                theBreaker.reset();
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testStopAndWaitSectionDecorator1() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            String theSenderData = "The weather is good this morning. Temperature is about 20 degrees, some rain, much sun.";
            CrcSegmentDecorator theSenderSeg = SerialSugar.crcPrefixSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.stopAndWaitSection((Section)SerialSugar.stringSection((String)theSenderData))), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
            StringSection theReceiverSection = SerialSugar.stringSection();
            CrcSegmentDecorator theReceiverSeg = SerialSugar.crcPrefixSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.stopAndWaitSection((Section)theReceiverSection)), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
            for (int i = 0; i < 3; ++i) {
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                theResult.waitForResult();
                String theReceiverData = (String)theReceiverSection.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(theReceiverData);
                }
                Assertions.assertEquals((Object)theSenderData, (Object)theReceiverData);
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }

    @Test
    public void testStopAndWaitSectionDecorator2() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
        if (this.hasPorts()) {
            Port theTransmitPort = (Port)this.getTransmitterPort().withOpen();
            Port theReceiverPort = (Port)this.getReceiverPort().withOpen();
            String theSenderData = "The weather is good this morning. Temperature is about 20 degrees, some rain, much sun.";
            CrcSegmentDecorator theSenderSeg = SerialSugar.crcPrefixSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.stopAndWaitSection((Section)SerialSugar.stringSection((String)theSenderData))), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
            StringSection theReceiverSection = SerialSugar.stringSection();
            BreakerSectionDecorator theBreaker = SerialSugar.breakerSection((Section)theReceiverSection, (int)3);
            CrcSegmentDecorator theReceiverSeg = SerialSugar.crcPrefixSegment((Segment)SerialSugar.allocSegment((Section)SerialSugar.stopAndWaitSection((Section)theBreaker)), (CrcAlgorithm)CrcAlgorithmConfig.CRC_16_CCITT_FALSE);
            for (int i = 0; i < 3; ++i) {
                SegmentResult theResult = theReceiverPort.onReceiveSegment((Segment)theReceiverSeg);
                theSenderSeg.transmitTo((SerialTransceiver)theTransmitPort);
                theResult.waitForResult();
                String theReceiverData = (String)theReceiverSection.getPayload();
                if (IS_LOG_TESTS) {
                    System.out.println(theReceiverData);
                }
                Assertions.assertEquals((Object)theSenderData, (Object)theReceiverData);
                theBreaker.reset();
            }
            theTransmitPort.close();
            theReceiverPort.close();
        } else {
            System.out.println("Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!");
        }
    }
}

