/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.util.Arrays;

public class TestFixures {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    public static Values createValues() {
        Values theValues = new Values();
        theValues._booleans = new boolean[]{true, false, true, false, true, false, true, false, true, false};
        theValues._bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theValues._chars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        theValues._shorts = new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theValues._ints = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theValues._longs = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L};
        theValues._floats = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f};
        theValues._doubles = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0};
        theValues._strings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        return theValues;
    }

    public static Wrapper createWrapper() {
        Wrapper theWrapper = new Wrapper();
        theWrapper._booleans = new Boolean[]{true, false, true, false, true, false, true, false, true, false};
        theWrapper._bytes = new Byte[]{(byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)0};
        theWrapper._chars = new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('0')};
        theWrapper._shorts = new Short[]{(short)1, (short)2, (short)3, (short)4, (short)5, (short)6, (short)7, (short)8, (short)9, (short)0};
        theWrapper._ints = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theWrapper._longs = new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L};
        theWrapper._floats = new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f), Float.valueOf(8.0f), Float.valueOf(9.0f), Float.valueOf(0.0f)};
        theWrapper._doubles = new Double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0};
        theWrapper._strings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        if (IS_LOG_TESTS) {
            System.out.println(theWrapper);
        }
        return theWrapper;
    }

    public static Sensors createSensors() {
        Sensors theSensors = new Sensors(new Sensor("TEMPX87", 17346), new Sensor("TEMPX03", 14346), new Sensor("TEMPY11", 9342), new Sensor("AUXLC33", 63483));
        return theSensors;
    }

    public static SensorValues createSensorValues() {
        SensorValues theSensorValues = new SensorValues();
        theSensorValues._valuesA._booleans = new boolean[]{true, false, true, false, true, false, true, false, true, false};
        theSensorValues._valuesA._bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theSensorValues._valuesA._chars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        theSensorValues._valuesA._shorts = new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theSensorValues._valuesA._ints = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theSensorValues._valuesA._longs = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L};
        theSensorValues._valuesA._floats = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f};
        theSensorValues._valuesA._doubles = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0};
        theSensorValues._valuesA._strings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        theSensorValues._valuesB._booleans = new boolean[]{true, false, true, false, true, false, true, false, true, false};
        theSensorValues._valuesB._bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theSensorValues._valuesB._chars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        theSensorValues._valuesB._shorts = new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theSensorValues._valuesB._ints = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theSensorValues._valuesB._longs = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L};
        theSensorValues._valuesB._floats = new float[]{1.1f, 2.2f, 3.3f, 4.4f, 5.5f, 6.6f, 7.7f, 8.8f, 9.9f, 0.0f};
        theSensorValues._valuesB._doubles = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0};
        theSensorValues._valuesB._strings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        theSensorValues._valuesC._booleans = new boolean[]{true, false, true, false, true, false, true, false, true, false};
        theSensorValues._valuesC._bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theSensorValues._valuesC._chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J'};
        theSensorValues._valuesC._shorts = new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theSensorValues._valuesC._ints = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theSensorValues._valuesC._longs = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L};
        theSensorValues._valuesC._floats = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f};
        theSensorValues._valuesC._doubles = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0};
        theSensorValues._valuesC._strings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        theSensorValues._valuesD._booleans = new boolean[]{true, false, true, false, true, false, true, false, true, false};
        theSensorValues._valuesD._bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theSensorValues._valuesD._chars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        theSensorValues._valuesD._shorts = new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theSensorValues._valuesD._ints = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        theSensorValues._valuesD._longs = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 0L};
        theSensorValues._valuesD._floats = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 0.0f};
        theSensorValues._valuesD._doubles = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0};
        theSensorValues._valuesD._strings = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J"};
        return theSensorValues;
    }

    protected static WeatherData createWeatherData() {
        WeatherData theSensors = new WeatherData(new Sensor("WIND01", 17346), new Sensor("TEMP01", 14346), new Sensor("HUM01", 9342), new Sensor("WIND02", 978), new Sensor("TEMP02", -878), new Sensor("HUM02", -1));
        return theSensors;
    }

    public static class Values {
        public boolean[] _booleans;
        public byte[] _bytes;
        public char[] _chars;
        public short[] _shorts;
        public int[] _ints;
        public long[] _longs;
        public float[] _floats;
        public double[] _doubles;
        public String[] _strings;

        public String toString() {
            return "Values [booleans=" + Arrays.toString(this._booleans) + ", bytes=" + Arrays.toString(this._bytes) + ", chars=" + Arrays.toString(this._chars) + ", short=" + Arrays.toString(this._shorts) + ", ints=" + Arrays.toString(this._ints) + ", longs=" + Arrays.toString(this._longs) + ", floats=" + Arrays.toString(this._floats) + ", doubles=" + Arrays.toString(this._doubles) + ", strings=" + Arrays.toString(this._strings) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this._booleans);
            result = 31 * result + Arrays.hashCode(this._bytes);
            result = 31 * result + Arrays.hashCode(this._chars);
            result = 31 * result + Arrays.hashCode(this._doubles);
            result = 31 * result + Arrays.hashCode(this._ints);
            result = 31 * result + Arrays.hashCode(this._longs);
            result = 31 * result + Arrays.hashCode(this._shorts);
            result = 31 * result + Arrays.hashCode(this._strings);
            result = 31 * result + Arrays.hashCode(this._floats);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Values other = (Values)obj;
            if (!Arrays.equals(this._booleans, other._booleans)) {
                return false;
            }
            if (!Arrays.equals(this._bytes, other._bytes)) {
                return false;
            }
            if (!Arrays.equals(this._chars, other._chars)) {
                return false;
            }
            if (!Arrays.equals(this._doubles, other._doubles)) {
                return false;
            }
            if (!Arrays.equals(this._ints, other._ints)) {
                return false;
            }
            if (!Arrays.equals(this._longs, other._longs)) {
                return false;
            }
            if (!Arrays.equals(this._shorts, other._shorts)) {
                return false;
            }
            if (!Arrays.equals(this._strings, other._strings)) {
                return false;
            }
            return Arrays.equals(this._floats, other._floats);
        }
    }

    public static class Wrapper {
        public Boolean[] _booleans;
        public Byte[] _bytes;
        public Character[] _chars;
        public Short[] _shorts;
        public Integer[] _ints;
        public Long[] _longs;
        public Float[] _floats;
        public Double[] _doubles;
        public String[] _strings;

        public String toString() {
            return "Wrapper [booleans=" + Arrays.toString((Object[])this._booleans) + ", bytes=" + Arrays.toString((Object[])this._bytes) + ", chars=" + Arrays.toString((Object[])this._chars) + ", short=" + Arrays.toString((Object[])this._shorts) + ", ints=" + Arrays.toString((Object[])this._ints) + ", longs=" + Arrays.toString((Object[])this._longs) + ", floats=" + Arrays.toString((Object[])this._floats) + ", doubles=" + Arrays.toString((Object[])this._doubles) + ", strings=" + Arrays.toString(this._strings) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode((Object[])this._booleans);
            result = 31 * result + Arrays.hashCode((Object[])this._bytes);
            result = 31 * result + Arrays.hashCode((Object[])this._chars);
            result = 31 * result + Arrays.hashCode((Object[])this._doubles);
            result = 31 * result + Arrays.hashCode((Object[])this._floats);
            result = 31 * result + Arrays.hashCode((Object[])this._ints);
            result = 31 * result + Arrays.hashCode((Object[])this._longs);
            result = 31 * result + Arrays.hashCode((Object[])this._shorts);
            result = 31 * result + Arrays.hashCode(this._strings);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Wrapper other = (Wrapper)obj;
            if (!Arrays.equals((Object[])this._booleans, (Object[])other._booleans)) {
                return false;
            }
            if (!Arrays.equals((Object[])this._bytes, (Object[])other._bytes)) {
                return false;
            }
            if (!Arrays.equals((Object[])this._chars, (Object[])other._chars)) {
                return false;
            }
            if (!Arrays.equals((Object[])this._doubles, (Object[])other._doubles)) {
                return false;
            }
            if (!Arrays.equals((Object[])this._floats, (Object[])other._floats)) {
                return false;
            }
            if (!Arrays.equals((Object[])this._ints, (Object[])other._ints)) {
                return false;
            }
            if (!Arrays.equals((Object[])this._longs, (Object[])other._longs)) {
                return false;
            }
            if (!Arrays.equals((Object[])this._shorts, (Object[])other._shorts)) {
                return false;
            }
            return Arrays.equals(this._strings, other._strings);
        }
    }

    public static class Sensors {
        public Sensor _sensorA;
        public Sensor _sensorB;
        public Sensor _sensorC;
        public Sensor _sensorD;

        public Sensors() {
        }

        public Sensors(Sensor aSensorA, Sensor aSensorB, Sensor aSensorC, Sensor aSensorD) {
            this._sensorA = aSensorA;
            this._sensorB = aSensorB;
            this._sensorC = aSensorC;
            this._sensorD = aSensorD;
        }

        public String toString() {
            return "Sensors [sensorA=" + this._sensorA + ", sensorB=" + this._sensorB + ", sensorC=" + this._sensorC + ", sensorD=" + this._sensorD + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._sensorA == null ? 0 : this._sensorA.hashCode());
            result = 31 * result + (this._sensorB == null ? 0 : this._sensorB.hashCode());
            result = 31 * result + (this._sensorC == null ? 0 : this._sensorC.hashCode());
            result = 31 * result + (this._sensorD == null ? 0 : this._sensorD.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Sensors other = (Sensors)obj;
            if (this._sensorA == null ? other._sensorA != null : !this._sensorA.equals(other._sensorA)) {
                return false;
            }
            if (this._sensorB == null ? other._sensorB != null : !this._sensorB.equals(other._sensorB)) {
                return false;
            }
            if (this._sensorC == null ? other._sensorC != null : !this._sensorC.equals(other._sensorC)) {
                return false;
            }
            return !(this._sensorD == null ? other._sensorD != null : !this._sensorD.equals(other._sensorD));
        }
    }

    public static class Sensor {
        public int _value;
        public String _name;

        public Sensor() {
        }

        public Sensor(String aName, int aValue) {
            this._name = aName;
            this._value = aValue;
        }

        public String getName() {
            return this._name;
        }

        public int getPayload() {
            return this._value;
        }

        public String toString() {
            return "Sensor [value=" + this._value + ", name=" + this._name + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + this._value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Sensor other = (Sensor)obj;
            if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
                return false;
            }
            return this._value == other._value;
        }
    }

    public static class SensorValues {
        public Values _valuesA = new Values();
        public Values _valuesB = new Values();
        public Values _valuesC = new Values();
        public Values _valuesD = new Values();

        public String toString() {
            return "SensorValues [valuesA=" + this._valuesA + ", valuesB=" + this._valuesB + ", valuesC=" + this._valuesC + ", valuesD=" + this._valuesD + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._valuesA == null ? 0 : this._valuesA.hashCode());
            result = 31 * result + (this._valuesB == null ? 0 : this._valuesB.hashCode());
            result = 31 * result + (this._valuesC == null ? 0 : this._valuesC.hashCode());
            result = 31 * result + (this._valuesD == null ? 0 : this._valuesD.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SensorValues other = (SensorValues)obj;
            if (this._valuesA == null ? other._valuesA != null : !this._valuesA.equals(other._valuesA)) {
                return false;
            }
            if (this._valuesB == null ? other._valuesB != null : !this._valuesB.equals(other._valuesB)) {
                return false;
            }
            if (this._valuesC == null ? other._valuesC != null : !this._valuesC.equals(other._valuesC)) {
                return false;
            }
            return !(this._valuesD == null ? other._valuesD != null : !this._valuesD.equals(other._valuesD));
        }
    }

    public static class WeatherData {
        private Sensor[] _sensors;

        public WeatherData() {
        }

        public WeatherData(Sensor ... sensors) {
            this._sensors = sensors;
        }

        public Sensor[] getSensors() {
            return this._sensors;
        }

        public void setSensors(Sensor[] sensors) {
            this._sensors = sensors;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this._sensors);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WeatherData other = (WeatherData)obj;
            return Arrays.equals(this._sensors, other._sensors);
        }

        public String toString() {
            return "WeatherData [sensors=" + Arrays.toString(this._sensors) + "]";
        }
    }

    public static class SensorArray {
        public Sensor[] sensors;

        public SensorArray() {
        }

        public SensorArray(Sensor[] sensors) {
            this.sensors = sensors;
        }

        public Sensor[] getSensors() {
            return this.sensors;
        }

        public void setSensors(Sensor[] sensors) {
            this.sensors = sensors;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.sensors);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SensorArray other = (SensorArray)obj;
            return Arrays.equals(this.sensors, other.sensors);
        }

        public String toString() {
            return "SensorArray [sensors=" + Arrays.toString(this.sensors) + "]";
        }
    }
}

