/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.exception.BugException;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.mixin.DecorateeAccessor;
import org.refcodes.numerical.AbstractCrcMixin;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcChecksumAccessor;
import org.refcodes.numerical.CrcMixin;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapImpl;

public abstract class AbstractCrcTransmissionDecorator<DECORATEE extends Transmission>
extends AbstractCrcMixin
implements Transmission,
Transmission.TransmissionMixin,
DecorateeAccessor<DECORATEE>,
CrcMixin,
CrcChecksumAccessor {
    private static final long serialVersionUID = 1L;
    public static final String CRC_ENDIANESS = "CRC_ENDIANESS";
    public static final String CRC_CHECKSUM = "CRC_CHECKSUM";
    public static final String CRC_CHECKSUM_HEX = "CRC_CHECKSUM_HEX";
    public static final String CRC_ALGORITHM = "CRC_ALGORITHM";
    public static final String CRC_BYTE_WIDTH = "CRC_BYTE_WIDTH";
    public static final String CRC_CHECKSUM_CONCATENATION_MODE = "CRC_CHECKSUM_CONCATENATION_MODE";
    public static final String CRC_CHECKSUM_LITTLE_ENDIAN_BYTES = "CRC_CHECKSUM_LITTLE_ENDIAN_BYTES";
    public static final String CRC_CHECKSUM_BIG_ENDIAN_BYTES = "CRC_CHECKSUM_BIG_ENDIAN_BYTES";
    protected DECORATEE _decoratee;
    protected long _crcChecksum = -1L;

    public AbstractCrcTransmissionDecorator(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        this(aDecoratee, aTransmissionMetrics.getCrcAlgorithm(), aTransmissionMetrics.getCrcChecksumConcatenateMode(), aTransmissionMetrics.getChecksumValidationMode(), aTransmissionMetrics.getEndianess());
    }

    public AbstractCrcTransmissionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm) {
        this(aDecoratee, aCrcAlgorithm, TransmissionMetrics.DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE, TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractCrcTransmissionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode) {
        this(aDecoratee, aCrcAlgorithm, TransmissionMetrics.DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE, aChecksumValidationMode, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractCrcTransmissionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, Endianess aEndianess) {
        this(aDecoratee, aCrcAlgorithm, TransmissionMetrics.DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE, TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE, aEndianess);
    }

    public AbstractCrcTransmissionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        this(aDecoratee, aCrcAlgorithm, TransmissionMetrics.DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE, aChecksumValidationMode, aEndianess);
    }

    public AbstractCrcTransmissionDecorator(DECORATEE aDecoratee, ConcatenateMode aCrcChecksumConcatenateMode) {
        this(aDecoratee, TransmissionMetrics.DEFAULT_CRC_ALGORITHM, aCrcChecksumConcatenateMode, TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractCrcTransmissionDecorator(DECORATEE aDecoratee, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        this(aDecoratee, TransmissionMetrics.DEFAULT_CRC_ALGORITHM, aCrcChecksumConcatenateMode, TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE, aEndianess);
    }

    public AbstractCrcTransmissionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode) {
        this(aDecoratee, aCrcAlgorithm, aCrcChecksumConcatenateMode, TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractCrcTransmissionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode) {
        this(aDecoratee, aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractCrcTransmissionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        this(aDecoratee, aCrcAlgorithm, aCrcChecksumConcatenateMode, TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE, aEndianess);
    }

    public AbstractCrcTransmissionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        super(aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode, aEndianess);
        this._decoratee = aDecoratee;
    }

    @Override
    public Sequence toSequence() {
        Sequence theSequence = this._decoratee.toSequence();
        this._crcChecksum = theSequence.toCrcChecksum(this._crcAlgorithm);
        byte[] theCrcBytes = this.getEndianess().toUnsignedBytes(this._crcChecksum, this._crcAlgorithm.getCrcWidth());
        return theSequence.withConcatenate(this._crcChecksumConcatenateMode, theCrcBytes);
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        Sequence theSequence = this._decoratee.toSequence();
        this._crcChecksum = theSequence.toCrcChecksum(this._crcAlgorithm);
        byte[] theCrcBytes = this.getEndianess().toUnsignedBytes(this._crcChecksum, this._crcAlgorithm.getCrcWidth());
        switch (this._crcChecksumConcatenateMode) {
            case APPEND: {
                this._decoratee.transmitTo(aOutputStream, aReturnStream);
                aOutputStream.write(theCrcBytes);
                break;
            }
            case PREPEND: {
                aOutputStream.write(theCrcBytes);
                this._decoratee.transmitTo(aOutputStream, aReturnStream);
                break;
            }
            default: {
                throw new BugException("The value <" + this._crcChecksumConcatenateMode + "> of enumeration of type <" + ConcatenateMode.class.getName() + "> has been forgotten to implement!");
            }
        }
    }

    @Override
    public int getLength() {
        return this._crcAlgorithm.getCrcWidth() + this._decoratee.getLength();
    }

    public DECORATEE getDecoratee() {
        return this._decoratee;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCrcChecksum() {
        if (this._crcChecksum == -1L) {
            AbstractCrcTransmissionDecorator abstractCrcTransmissionDecorator = this;
            synchronized (abstractCrcTransmissionDecorator) {
                if (this._crcChecksum == -1L) {
                    Sequence theSequence = this._decoratee.toSequence();
                    this._crcChecksum = theSequence.toCrcChecksum(this._crcAlgorithm);
                }
            }
        }
        return this._crcChecksum;
    }

    @Override
    public SerialSchema toSchema() {
        long theChecksum = this.getCrcChecksum();
        SerialSchema theSchema = new SerialSchema(this.getClass(), "A segment decorator enriching the encapsulated segment with a CRC checksum.", this.toSequence(), this.getLength(), this.getDecoratee().toSchema());
        theSchema.put(CRC_CHECKSUM, theChecksum);
        theSchema.put(this.getEndianess() == Endianess.BIG ? CRC_CHECKSUM_BIG_ENDIAN_BYTES : CRC_CHECKSUM_LITTLE_ENDIAN_BYTES, this.getEndianess().toBytes(theChecksum, this.getCrcAlgorithm().getCrcWidth()));
        theSchema.put(CRC_CHECKSUM_HEX, this.getEndianess().toBytes(theChecksum, this.getCrcAlgorithm().getCrcWidth()));
        theSchema.put(CRC_ALGORITHM, this.getCrcAlgorithm());
        theSchema.put(CRC_BYTE_WIDTH, this.getCrcAlgorithm().getCrcWidth());
        theSchema.put(CRC_ENDIANESS, this.getEndianess());
        theSchema.put(CRC_CHECKSUM_CONCATENATION_MODE, this.getCrcChecksumConcatenateMode());
        return theSchema;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._crcChecksumConcatenateMode == null ? 0 : this._crcChecksumConcatenateMode.hashCode());
        result = 31 * result + (this._crcAlgorithm == null ? 0 : this._crcAlgorithm.hashCode());
        result = 31 * result + (int)(this._crcChecksum ^ this._crcChecksum >>> 32);
        result = 31 * result + (this._checksumValidationMode == null ? 0 : this._checksumValidationMode.hashCode());
        result = 31 * result + (this._endianess == null ? 0 : this._endianess.hashCode());
        result = 31 * result + (this._decoratee == null ? 0 : this._decoratee.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCrcTransmissionDecorator other = (AbstractCrcTransmissionDecorator)obj;
        if (this._crcChecksumConcatenateMode != other._crcChecksumConcatenateMode) {
            return false;
        }
        if (this._crcAlgorithm == null ? other._crcAlgorithm != null : !this._crcAlgorithm.equals(other._crcAlgorithm)) {
            return false;
        }
        if (this._crcChecksum != other._crcChecksum) {
            return false;
        }
        if (this._checksumValidationMode != other._checksumValidationMode) {
            return false;
        }
        if (this._endianess != other._endianess) {
            return false;
        }
        return !(this._decoratee == null ? other._decoratee != null : !this._decoratee.equals(other._decoratee));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [crcAlgorithm=" + this._crcAlgorithm + ", segment=" + this._decoratee + ", crcChecksum=" + this.getCrcChecksum() + ", crcMode=" + this._checksumValidationMode + ", endianess=" + this._endianess + ", concatenateMode=" + this._crcChecksumConcatenateMode + "]";
    }

    @Override
    public SimpleTypeMap toSimpleTypeMap() {
        return this._decoratee != null ? this._decoratee.toSimpleTypeMap() : new SimpleTypeMapImpl();
    }
}

