/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.mixin.DecorateeAccessor;
import org.refcodes.serial.ErrorCorrectionTransmission;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapImpl;

public abstract class AbstractErrorCorrectionTransmissionDecorator<DECORATEE extends Transmission>
implements ErrorCorrectionTransmission,
Transmission.TransmissionMixin,
DecorateeAccessor<DECORATEE> {
    private static final long serialVersionUID = 1L;
    public static final String ACK_TIMEOUT_IN_MS = "ACK_TIMEOUT_IN_MS";
    public static final String ACK_RETRY_NUMBER = "ACK_RETRY_NUMBER";
    protected int _acknowledgeRetryNumber;
    protected long _acknowledgeTimeoutInMs;
    protected DECORATEE _decoratee = null;

    public AbstractErrorCorrectionTransmissionDecorator(DECORATEE aSegment, TransmissionMetrics aTransmissionMetrics) {
        this(aSegment, aTransmissionMetrics.getAcknowledgeRetryNumber(), aTransmissionMetrics.getAcknowledgeTimeoutMillis());
    }

    protected AbstractErrorCorrectionTransmissionDecorator() {
        this(null, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS);
    }

    public AbstractErrorCorrectionTransmissionDecorator(DECORATEE aDecoratee) {
        this(aDecoratee, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS);
    }

    public AbstractErrorCorrectionTransmissionDecorator(DECORATEE aSegment, int aAckRetryNumber, long aAckTimeoutInMs) {
        this._decoratee = aSegment;
        this._acknowledgeTimeoutInMs = aAckTimeoutInMs;
        this._acknowledgeRetryNumber = aAckRetryNumber;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getClass(), "A transmission decorator enriching the encapsulated transmission with \"Stop-and-wait ARQ\".", this.toSequence(), this.getLength(), this.getDecoratee().toSchema());
        theSchema.put(ACK_RETRY_NUMBER, this.getAcknowledgeRetryNumber());
        theSchema.put(ACK_TIMEOUT_IN_MS, this.getAcknowledgeTimeoutMillis());
        return theSchema;
    }

    @Override
    public int getAcknowledgeRetryNumber() {
        return this._acknowledgeRetryNumber;
    }

    @Override
    public long getAcknowledgeTimeoutMillis() {
        return this._acknowledgeTimeoutInMs;
    }

    @Override
    public int getLength() {
        return this._decoratee.getLength();
    }

    @Override
    public Sequence toSequence() {
        return this._decoratee.toSequence();
    }

    public DECORATEE getDecoratee() {
        return this._decoratee;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [segment=" + this._decoratee + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._decoratee == null ? 0 : this._decoratee.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractErrorCorrectionTransmissionDecorator other = (AbstractErrorCorrectionTransmissionDecorator)obj;
        return !(this._decoratee == null ? other._decoratee != null : !this._decoratee.equals(other._decoratee));
    }

    @Override
    public SimpleTypeMap toSimpleTypeMap() {
        return this._decoratee != null ? this._decoratee.toSimpleTypeMap() : new SimpleTypeMapImpl();
    }
}

