/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.refcodes.mixin.EncodingAccessor;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.MagicBytesAccessor;
import org.refcodes.serial.MagicBytesLengthAccessor;
import org.refcodes.serial.PayloadTransmission;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapBuilderImpl;

public abstract class AbstractMagicBytesTransmission
implements PayloadTransmission<byte[]>,
Transmission.TransmissionMixin,
MagicBytesAccessor.MagicBytesProperty,
MagicBytesLengthAccessor,
EncodingAccessor<Charset> {
    private static final long serialVersionUID = 1L;
    public static final String MAGIC_BYTES = "MAGIC_BYTES";
    public static final String MAGIC_BYTES_TEXT = "MAGIC_BYTES_TEXT";
    protected byte[] _magicBytes;
    protected int _magicBytesLength;
    protected String _charset = TransmissionMetrics.DEFAULT_ENCODING.name();
    protected String _alias;

    public AbstractMagicBytesTransmission(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this._magicBytesLength = aTransmissionMetrics.getMagicBytesLength();
        this._alias = aAlias;
    }

    public AbstractMagicBytesTransmission(String aAlias, String aMagicBytes, TransmissionMetrics aTransmissionMetrics) {
        this._magicBytes = aMagicBytes.getBytes(aTransmissionMetrics.getEncoding());
        this._magicBytesLength = this._magicBytes != null ? this._magicBytes.length : aTransmissionMetrics.getMagicBytesLength();
        this._alias = aAlias;
    }

    public AbstractMagicBytesTransmission(String aAlias, byte[] aMagicBytes, TransmissionMetrics aTransmissionMetrics) {
        this._magicBytes = aMagicBytes;
        this._magicBytesLength = this._magicBytes != null ? this._magicBytes.length : aTransmissionMetrics.getMagicBytesLength();
        this._alias = aAlias;
    }

    public AbstractMagicBytesTransmission(String aAlias, int aMagicBytesLength) {
        this._magicBytesLength = aMagicBytesLength;
        this._alias = aAlias;
    }

    public AbstractMagicBytesTransmission(String aAlias, String aMagicBytes) {
        this(aAlias, aMagicBytes.getBytes(TransmissionMetrics.DEFAULT_ENCODING));
    }

    public AbstractMagicBytesTransmission(String aAlias, String aMagicBytes, Charset aCharset) {
        this(aAlias, aMagicBytes.getBytes(aCharset));
        this._charset = aCharset != null ? aCharset.name() : TransmissionMetrics.DEFAULT_ENCODING.name();
    }

    public AbstractMagicBytesTransmission(String aAlias, byte[] aMagicBytes) {
        this._magicBytes = aMagicBytes;
        this._magicBytesLength = aMagicBytes.length;
        this._alias = aAlias;
    }

    public void setPayload(byte[] aValue) {
        this._magicBytes = aValue;
    }

    public String getAlias() {
        return this._alias;
    }

    public byte[] getMagicBytes() {
        return this._magicBytes;
    }

    public void setMagicBytes(byte[] aMagicBytes) {
        this._magicBytes = aMagicBytes;
        this._magicBytesLength = aMagicBytes.length;
    }

    @Override
    public void setMagicBytes(String aMagicBytes) {
        this.setMagicBytes(aMagicBytes.getBytes(TransmissionMetrics.DEFAULT_ENCODING));
    }

    public void setMagicBytes(String aMagicBytes, Charset aCharset) {
        this.setMagicBytes(aMagicBytes.getBytes(aCharset));
    }

    public String toMagicBytesString() {
        return new String(this._magicBytes, this._charset != null ? this.getEncoding() : TransmissionMetrics.DEFAULT_ENCODING);
    }

    public String toMagicBytesString(String aCharset) {
        return new String(this._magicBytes, aCharset != null ? Charset.forName(aCharset) : (this._charset != null ? this.getEncoding() : TransmissionMetrics.DEFAULT_ENCODING));
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence(this._magicBytes);
    }

    @Override
    public int getMagicBytesLength() {
        return this._magicBytesLength;
    }

    public byte[] getPayload() {
        return this._magicBytes;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getClass(), "A segment representing magic bytes.", this.getAlias(), this.toSequence(), this.getLength());
        theSchema.put(MAGIC_BYTES, this.getMagicBytes());
        theSchema.put(MAGIC_BYTES_TEXT, this.toMagicBytesString());
        return theSchema;
    }

    public Charset getEncoding() {
        return this._charset != null ? Charset.forName(this._charset) : TransmissionMetrics.DEFAULT_ENCODING;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", magicBytes=" + NumericalUtility.toHexString((String)", ", (byte[])this._magicBytes) + ", magicBytesLength=" + this._magicBytesLength + ", charset=" + this._charset + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this._magicBytes);
        result = 31 * result + this._magicBytesLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMagicBytesTransmission other = (AbstractMagicBytesTransmission)obj;
        if (!Arrays.equals(this._magicBytes, other._magicBytes)) {
            return false;
        }
        return this._magicBytesLength == other._magicBytesLength;
    }

    @Override
    public SimpleTypeMap toSimpleTypeMap() {
        SimpleTypeMapBuilderImpl theBuilder = new SimpleTypeMapBuilderImpl();
        theBuilder.insertTo(this._alias, (Object)this._magicBytes);
        return theBuilder;
    }
}

