/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.refcodes.mixin.ChildrenAccessor;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.SerialTransceiver;
import org.refcodes.serial.Transmission;
import org.refcodes.struct.SimpleTypeMap;

public class AbstractMagicBytesTransmissionMultiplexer<CHILD extends Transmission>
implements Transmission,
Iterable<CHILD>,
ChildrenAccessor<CHILD[]> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_READ_LIMIT = 1024;
    protected CHILD[] _children;
    protected CHILD _responsibility;
    protected int _readLimit;

    protected AbstractMagicBytesTransmissionMultiplexer() {
    }

    @SafeVarargs
    public AbstractMagicBytesTransmissionMultiplexer(CHILD ... aSegments) {
        this(1024, (Transmission[])aSegments);
    }

    public AbstractMagicBytesTransmissionMultiplexer(Collection<CHILD> aSegments) {
        this(aSegments, 1024);
    }

    @SafeVarargs
    public AbstractMagicBytesTransmissionMultiplexer(int aReadLimit, CHILD ... aSegments) {
        this._children = aSegments;
        this._responsibility = this._children[0];
        this._readLimit = aReadLimit;
    }

    public AbstractMagicBytesTransmissionMultiplexer(Collection<CHILD> aSegments, int aReadLimit) {
        this(aReadLimit, AbstractMagicBytesTransmissionMultiplexer.toArray(aSegments));
    }

    @Override
    public int getLength() {
        return this._responsibility.getLength();
    }

    @Override
    public Sequence toSequence() {
        return this._responsibility.toSequence();
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        this._responsibility.transmitTo(aOutputStream, aReturnStream);
    }

    @Override
    public SerialSchema toSchema() {
        return new SerialSchema(this.getClass(), "The magic bytes multiplexer transmission passes transmissions to the segment responsible for the transmission's magic bytes.", new SerialSchema[0]);
    }

    @Override
    public SimpleTypeMap toSimpleTypeMap() {
        return this._responsibility.toSimpleTypeMap();
    }

    @Override
    public void transmitTo(OutputStream aOutputStream) throws IOException {
        this._responsibility.transmitTo(aOutputStream);
    }

    @Override
    public void transmitTo(SerialTransceiver aSerialTransceiver) throws IOException {
        this._responsibility.transmitTo(aSerialTransceiver);
    }

    @Override
    public Iterator<CHILD> iterator() {
        return Arrays.asList(this._children).iterator();
    }

    public CHILD[] getChildren() {
        return this._children;
    }

    public CHILD getCallee() {
        return this._responsibility;
    }

    private static <CHILD extends Transmission> CHILD[] toArray(Collection<CHILD> aSegments) {
        Transmission[] theChildren;
        if (aSegments != null && aSegments.size() != 0) {
            theChildren = new Transmission[aSegments.size()];
            theChildren = aSegments.toArray(theChildren);
        } else {
            theChildren = new Transmission[]{};
        }
        return theChildren;
    }
}

