/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.EndianessAccessor;
import org.refcodes.serial.AllocLengthAccessor;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.LengthWidthAccessor;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapImpl;

public abstract class AbstractReferenceeLengthSegment<REFERENCEE extends Transmission>
implements Segment,
Transmission.TransmissionMixin,
LengthWidthAccessor,
EndianessAccessor,
AllocLengthAccessor {
    private static final long serialVersionUID = 1L;
    public static final String ALLOC_LENGTH = "ALLOC_LENGTH";
    public static final String ALLOC_LENGTH_WIDTH = "ALLOC_LENGTH_WIDTH";
    public static final String ENDIANESS = "ENDIANESS";
    protected Endianess _endianess;
    protected int _lengthWidth;
    protected int _allocLength = -1;
    protected REFERENCEE _referencee = null;

    public AbstractReferenceeLengthSegment(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess());
    }

    public AbstractReferenceeLengthSegment(REFERENCEE aReferencee, TransmissionMetrics aTransmissionMetrics) {
        this(aReferencee, aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess());
    }

    public AbstractReferenceeLengthSegment() {
        this(4, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractReferenceeLengthSegment(Endianess aEndianess) {
        this(4, aEndianess);
    }

    public AbstractReferenceeLengthSegment(int aLengthWidth) {
        this(aLengthWidth, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractReferenceeLengthSegment(int aLengthWidth, Endianess aEndianess) {
        this(null, aLengthWidth, aEndianess);
    }

    public AbstractReferenceeLengthSegment(REFERENCEE aReferencee) {
        this(aReferencee, 4, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractReferenceeLengthSegment(REFERENCEE aReferencee, Endianess aEndianess) {
        this(aReferencee, 4, aEndianess);
    }

    public AbstractReferenceeLengthSegment(REFERENCEE aReferencee, int aLengthWidth) {
        this(aReferencee, aLengthWidth, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractReferenceeLengthSegment(REFERENCEE aReferencee, int aLengthWidth, Endianess aEndianess) {
        this._endianess = aEndianess;
        this._lengthWidth = aLengthWidth;
        this._referencee = aReferencee;
    }

    @Override
    public int getLengthWidth() {
        return this._lengthWidth;
    }

    @Override
    public Sequence toSequence() {
        int theAllocLength;
        int n = this._allocLength != -1 ? this._allocLength : (theAllocLength = this._referencee != null ? this._referencee.getLength() : 0);
        if (this._allocLength == -1) {
            this._allocLength = theAllocLength;
        }
        return new ByteArraySequence(this._endianess.toBytes(theAllocLength, this._lengthWidth));
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        byte[] theBuffer = aSequence.toBytes(aOffset, this._lengthWidth);
        this._allocLength = this._endianess.toUnsignedInteger(theBuffer);
        return aOffset + this._lengthWidth;
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException, TransmissionException {
        byte[] theBuffer = new byte[this._lengthWidth];
        aInputStream.read(theBuffer, 0, this._lengthWidth);
        this._allocLength = this._endianess.toUnsignedInteger(theBuffer);
    }

    @Override
    public int getLength() {
        return this._lengthWidth;
    }

    public Endianess getEndianess() {
        return this._endianess;
    }

    @Override
    public int getAllocLength() {
        return this._allocLength;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getClass(), "An allocation value referencing a segment which's length is to be allocated and allocating that length in bytes.", this.toSequence(), "" + this.getAllocLength(), this.getLength());
        theSchema.put(ENDIANESS, this._endianess);
        theSchema.put(ALLOC_LENGTH_WIDTH, this._lengthWidth);
        theSchema.put(ALLOC_LENGTH, this._allocLength);
        return theSchema;
    }

    public int hashCode() {
        return Objects.hash(this._referencee, this._endianess, this._lengthWidth, this._allocLength);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractReferenceeLengthSegment)) {
            return false;
        }
        AbstractReferenceeLengthSegment other = (AbstractReferenceeLengthSegment)obj;
        return Objects.equals(this._referencee, other._referencee) && this._endianess == other._endianess && this._lengthWidth == other._lengthWidth && this._allocLength == other._allocLength;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [endianess=" + this._endianess + ", lengthWidth=" + this._lengthWidth + ", value=" + this._allocLength + "]";
    }

    @Override
    public SimpleTypeMap toSimpleTypeMap() {
        return this._referencee != null ? this._referencee.toSimpleTypeMap() : new SimpleTypeMapImpl();
    }
}

