/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.EndianessAccessor;
import org.refcodes.serial.AbstractPayloadSegment;
import org.refcodes.serial.AsciizSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.EndOfStringByteAccessor;
import org.refcodes.serial.LengthWidthAccessor;
import org.refcodes.serial.NumberSegment;
import org.refcodes.serial.PayloadSegment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapBuilderImpl;
import org.refcodes.textual.CaseStyleBuilder;
import org.refcodes.textual.VerboseTextBuilder;

public class AsciizArraySegment
extends AbstractPayloadSegment<String[]>
implements PayloadSegment<String[]>,
LengthWidthAccessor,
EndianessAccessor,
EndOfStringByteAccessor {
    private static final long serialVersionUID = 1L;
    private NumberSegment _lengthSegment;
    private int _lengthWidth;
    private Endianess _endianess;
    private byte _endOfStringByte;

    public AsciizArraySegment(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEndOfStringByte(), aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), new String[0]);
    }

    public AsciizArraySegment(TransmissionMetrics aTransmissionMetrics, String ... aValue) {
        this(aTransmissionMetrics.getEndOfStringByte(), aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aValue);
    }

    public AsciizArraySegment(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getEndOfStringByte(), aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), new String[0]);
    }

    public AsciizArraySegment(String aAlias, TransmissionMetrics aTransmissionMetrics, String ... aValue) {
        this(aAlias, aTransmissionMetrics.getEndOfStringByte(), aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), aValue);
    }

    public AsciizArraySegment(String ... aPayload) {
        this(CaseStyleBuilder.asCamelCase((String)AsciizArraySegment.class.getSimpleName()), 0, 4, TransmissionMetrics.DEFAULT_ENDIANESS, aPayload);
    }

    public AsciizArraySegment(int aLengthWidth, Endianess aEndianess, String ... aPayload) {
        this(CaseStyleBuilder.asCamelCase((String)AsciizArraySegment.class.getSimpleName()), 0, aLengthWidth, aEndianess, aPayload);
    }

    public AsciizArraySegment(String aAlias, int aLengthWidth, Endianess aEndianess, String ... aPayload) {
        this(aAlias, 0, aLengthWidth, aEndianess, aPayload);
    }

    public AsciizArraySegment(String aAlias, TransmissionMetrics aTransmissionMetrics, byte aEndOfStringByte) {
        this(aAlias, aTransmissionMetrics.getEndOfStringByte(), aTransmissionMetrics.getLengthWidth(), aTransmissionMetrics.getEndianess(), new String[0]);
    }

    public AsciizArraySegment(byte aEndOfStringByte, String ... aPayload) {
        this(CaseStyleBuilder.asCamelCase((String)AsciizArraySegment.class.getSimpleName()), aEndOfStringByte, 4, TransmissionMetrics.DEFAULT_ENDIANESS, aPayload);
    }

    public AsciizArraySegment(byte aEndOfStringByte, int aLengthWidth, Endianess aEndianess, String ... aPayload) {
        this(CaseStyleBuilder.asCamelCase((String)AsciizArraySegment.class.getSimpleName()), aEndOfStringByte, aLengthWidth, aEndianess, aPayload);
    }

    public AsciizArraySegment(String aAlias, byte aEndOfStringByte, int aLengthWidth, Endianess aEndianess, String ... aPayload) {
        super(aAlias, aPayload);
        this._alias = aAlias;
        this._lengthWidth = aLengthWidth;
        this._endianess = aEndianess;
        this._lengthSegment = new NumberSegment(this._lengthWidth, this._endianess);
        this._endOfStringByte = aEndOfStringByte;
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        int eOffset = this._lengthSegment.fromTransmission(aSequence, aOffset);
        int theSize = this._lengthSegment.getValue().intValue();
        this._payload = new String[theSize];
        AsciizSegment theAsciizSegment = new AsciizSegment(this._endOfStringByte);
        for (int i = 0; i < theSize; ++i) {
            eOffset = theAsciizSegment.fromTransmission(aSequence, eOffset);
            ((String[])this._payload)[i] = (String)theAsciizSegment.getPayload();
        }
        return eOffset;
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException, TransmissionException {
        this._lengthSegment.receiveFrom(aInputStream, aReturnStream);
        int theSize = this._lengthSegment.getValue().intValue();
        String[] thePayload = new String[theSize];
        AsciizSegment theAsciizSegment = new AsciizSegment(this._endOfStringByte);
        for (int i = 0; i < theSize; ++i) {
            theAsciizSegment.receiveFrom(aInputStream, aReturnStream);
            thePayload[i] = (String)theAsciizSegment.getPayload();
        }
    }

    @Override
    public Sequence toSequence() {
        ByteArraySequence theSequence = new ByteArraySequence();
        this._lengthSegment.setValue(this._payload != null ? (long)((String[])this._payload).length : 0L);
        theSequence.append(this._lengthSegment.toSequence());
        int theSize = this._lengthSegment.getValue().intValue();
        AsciizSegment theAsciizSegment = new AsciizSegment(this._endOfStringByte);
        for (int i = 0; i < theSize; ++i) {
            theAsciizSegment.setPayload(((String[])this._payload)[i]);
            theSequence.append(theAsciizSegment.toSequence());
        }
        return theSequence;
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        this._lengthSegment.setValue(this._payload != null ? (long)((String[])this._payload).length : 0L);
        this._lengthSegment.transmitTo(aOutputStream, aReturnStream);
        int theSize = this._lengthSegment.getValue().intValue();
        AsciizSegment theAsciizSegment = new AsciizSegment(this._endOfStringByte);
        for (int i = 0; i < theSize; ++i) {
            theAsciizSegment.setPayload(((String[])this._payload)[i]);
            theAsciizSegment.transmitTo(aOutputStream, aReturnStream);
        }
    }

    @Override
    public SerialSchema toSchema() {
        int theSize = this._payload != null ? ((String[])this._payload).length : 0;
        SerialSchema[] theSchemas = new SerialSchema[theSize + 1];
        theSchemas[0] = this._lengthSegment.toSchema();
        for (int i = 0; i < ((String[])this._payload).length; ++i) {
            theSchemas[i + 1] = new AsciizSegment(((String[])this._payload)[i], this._endOfStringByte).toSchema();
        }
        return new SerialSchema(this.getClass(), "A segment containing an ASCIIZ string array  payload prefixed by the number of array elements.", this.getAlias(), this.toSequence(), VerboseTextBuilder.asString((String[])((String[])this.getPayload())), this.getLength(), theSchemas);
    }

    @Override
    public int getLength() {
        int thePayloadLength = 0;
        if (this._payload != null) {
            for (int i = 0; i < ((String[])this._payload).length; ++i) {
                thePayloadLength += ((String[])this._payload)[i].length() + 1;
            }
        }
        return this._lengthSegment.getLength() + thePayloadLength;
    }

    public AsciizArraySegment withPayload(String[] aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public int getLengthWidth() {
        return this._lengthWidth;
    }

    public Endianess getEndianess() {
        return this._endianess;
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public SimpleTypeMap toSimpleTypeMap() {
        return new SimpleTypeMapBuilderImpl().withInsertTo(this._alias, this.getPayload());
    }

    @Override
    public byte getEndOfStringByte() {
        return this._endOfStringByte;
    }
}

