/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.util.Arrays;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.serial.AbstractPayloadSection;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.PayloadSection;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionSequenceException;
import org.refcodes.textual.CaseStyleBuilder;

public class BooleanArraySection
extends AbstractPayloadSection<boolean[]>
implements PayloadSection<boolean[]> {
    private static final long serialVersionUID = 1L;

    public BooleanArraySection() {
        this(CaseStyleBuilder.asCamelCase((String)BooleanArraySection.class.getSimpleName()));
    }

    public BooleanArraySection(boolean ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)BooleanArraySection.class.getSimpleName()), aValue);
    }

    public BooleanArraySection(Boolean ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)BooleanArraySection.class.getSimpleName()), aValue);
    }

    public BooleanArraySection(String aAlias) {
        this(aAlias, new boolean[0]);
    }

    public BooleanArraySection(String aAlias, boolean ... aValue) {
        super(aAlias, aValue);
    }

    public BooleanArraySection(String aAlias, Boolean ... aValue) {
        this(aAlias, BooleanArraySection.toPrimitiveArray(aValue));
    }

    @Override
    public Sequence toSequence() {
        boolean[] theBooleans = (boolean[])this.getPayload();
        Sequence theHeader = this.toHeader(theBooleans);
        Sequence theBody = this.toBody(theBooleans);
        Sequence theTransmission = theHeader.toAppend(theBody);
        return theTransmission;
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        byte[] theRecord = aSequence.toBytes(aOffset, aLength);
        byte theModulo = theRecord[0];
        if (theModulo >= 8) {
            throw new TransmissionSequenceException(aSequence, "The number of bits <" + theModulo + "> specified by the header still belonging to the payload of the body's last byte must not be greater than or equal to <8>!");
        }
        if (theRecord.length > 1) {
            int theOpenByte = theModulo == 0 ? 0 : 1;
            int theArrayLength = (theRecord.length - theOpenByte - 1) * 8 + theModulo;
            boolean[] theBooleans = NumericalUtility.toBooleans((byte[])theRecord, (int)1, (int)theArrayLength);
            this.setPayload(theBooleans);
        } else {
            if (theRecord.length == 1 && theModulo != 0) {
                throw new TransmissionSequenceException(aSequence, "The sequence just contains one (header) value <" + theModulo + "> which should be <0> as the there cannot be any succeeding bits for an empty array!");
            }
            if (theRecord.length == 0) {
                throw new TransmissionSequenceException(aSequence, "The sequence is empty, cannot determine the header!");
            }
        }
    }

    @Override
    public int getLength() {
        return this.getPayload() != null ? ((boolean[])this.getPayload()).length / 8 + (((boolean[])this.getPayload()).length % 8 == 0 ? 0 : 1) + 1 : 0;
    }

    @Override
    public SerialSchema toSchema() {
        Sequence theHeader = this.toHeader((boolean[])this.getPayload());
        Sequence theBody = this.toBody((boolean[])this.getPayload());
        SerialSchema theHeaderSchema = new SerialSchema(this.getClass(), "A header containing the number of booleans in the last byte belonging to the payload represented by the succeeding byte array.", this.getAlias() + ".Header", theHeader, theHeader.getLength());
        Object theBitField = "";
        for (int i = 0; i < ((boolean[])this.getPayload()).length; ++i) {
            if (i != 0 && i % 8 == 0) {
                theBitField = (String)theBitField + " ";
            }
            theBitField = (String)theBitField + (((boolean[])this.getPayload())[i] ? "1" : "0");
        }
        SerialSchema theBodySchema = new SerialSchema(this.getClass(), "A body containing a boolean array payload represented by a byte array (as of the header's value not all bits of the last byte necessarily belong to the payload!).", this.getAlias() + ".Body", theBody, (String)theBitField, theBody.getLength());
        return new SerialSchema(this.getClass(), "A body containing a byte array representing a boolean array payload prefixed with the number of booleans.", this.getAlias(), this.toSequence(), this.getLength(), theHeaderSchema, theBodySchema);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", value=" + Arrays.toString((boolean[])this.getPayload()) + "]";
    }

    public BooleanArraySection withPayload(boolean[] aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public void setPayload(Boolean[] aPayload) {
        this.setPayload(BooleanArraySection.toPrimitiveArray(aPayload));
    }

    public BooleanArraySection withPayload(Boolean[] aPayload) {
        this.setPayload(BooleanArraySection.toPrimitiveArray(aPayload));
        return this;
    }

    private static boolean[] toPrimitiveArray(Boolean[] aPayload) {
        boolean[] theResult = new boolean[aPayload.length];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = aPayload[i];
        }
        return theResult;
    }

    private Sequence toHeader(boolean[] aBooleans) {
        return new ByteArraySequence((byte)(aBooleans.length % 8));
    }

    private Sequence toBody(boolean[] aBooleans) {
        byte[] theRecord = NumericalUtility.toBytes((boolean[])aBooleans);
        ByteArraySequence theBody = new ByteArraySequence(theRecord);
        return theBody;
    }
}

