/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.mixin.Resetable;
import org.refcodes.serial.AbstractTransmissionDecorator;
import org.refcodes.serial.DecoratorSegment;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionSequenceException;

public class BreakerSegmentDecorator<DECORATEE extends Segment>
extends AbstractTransmissionDecorator<DECORATEE>
implements DecoratorSegment<DECORATEE>,
Resetable {
    private static final long serialVersionUID = 1L;
    public static final String BREAK_NUMBER = "BREAK_NUMBER";
    public static final String BREAK_COUNT = "BREAK_COUNT";
    protected int _breakNumber;
    protected int _breakCount = 0;
    protected long _startTime;

    protected BreakerSegmentDecorator() {
    }

    public BreakerSegmentDecorator(DECORATEE aDecoratee, int aBreakNumber) {
        super(aDecoratee);
        this._breakNumber = aBreakNumber;
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        if (this._breakCount == 0) {
            this._startTime = System.currentTimeMillis();
        }
        if (this._breakCount < this._breakNumber) {
            ++this._breakCount;
            System.out.println(this.getClass().getSimpleName() + ".fromTransmission(): Reached break <" + this._breakCount + "> out of <" + this._breakNumber + ">" + (String)(this._breakCount == 1 ? "" : " after " + (System.currentTimeMillis() - this._startTime) / 1000L + " seconds") + "...");
            throw new TransmissionSequenceException(aSequence, "Breaking reception occurrence <" + this._breakCount + "> out of <" + this._breakNumber + "> occurrences.");
        }
        return ((Segment)this._decoratee).fromTransmission(aSequence, aOffset);
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException, TransmissionException {
        if (this._breakCount == 0) {
            this._startTime = System.currentTimeMillis();
        }
        if (this._breakCount < this._breakNumber) {
            ++this._breakCount;
            System.out.println(this.getClass().getSimpleName() + ".receiveFrom(): Reached break <" + this._breakCount + "> out of <" + this._breakNumber + ">" + (String)(this._breakCount == 1 ? "" : " after " + (System.currentTimeMillis() - this._startTime) / 1000L + " seconds") + "...");
            throw new TransmissionException("Breaking reception occurrence <" + this._breakCount + "> out of <" + this._breakNumber + "> occurrences.");
        }
        ((Segment)this._decoratee).receiveFrom(aInputStream, aReturnStream);
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getClass(), "A segment decorator for testing purpose enriching the encapsulated segment with a serialization breaker.", this.toSequence(), this.getLength(), ((Segment)this.getDecoratee()).toSchema());
        theSchema.put(BREAK_NUMBER, this._breakNumber);
        theSchema.put(BREAK_COUNT, this._breakCount);
        return theSchema;
    }

    public void reset() {
        this._breakCount = 0;
    }
}

