/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.util.Arrays;
import org.refcodes.serial.AbstractPayloadSection;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.PayloadSection;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.textual.CaseStyleBuilder;

public class ByteArraySection
extends AbstractPayloadSection<byte[]>
implements PayloadSection<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySection() {
        this(CaseStyleBuilder.asCamelCase((String)ByteArraySection.class.getSimpleName()));
    }

    public ByteArraySection(byte[] aPayload) {
        this(CaseStyleBuilder.asCamelCase((String)ByteArraySection.class.getSimpleName()), aPayload);
    }

    public ByteArraySection(Byte[] aPayload) {
        this(CaseStyleBuilder.asCamelCase((String)ByteArraySection.class.getSimpleName()), aPayload);
    }

    public ByteArraySection(String aAlias) {
        super(aAlias, new byte[0]);
    }

    public ByteArraySection(String aAlias, byte[] aPayload) {
        super(aAlias, aPayload);
    }

    public ByteArraySection(String aAlias, Byte[] aPayload) {
        super(aAlias, ByteArraySection.toPrimitiveArray(aPayload));
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence((byte[])this.getPayload());
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        byte[] theRecord = aSequence.toBytes(aOffset, aLength);
        this.setPayload(theRecord);
    }

    @Override
    public int getLength() {
        return this.getPayload() != null ? ((byte[])this.getPayload()).length * 1 : 0;
    }

    @Override
    public SerialSchema toSchema() {
        return new SerialSchema(this.getClass(), "A body containing a byte array payload.", this.getAlias(), this.toSequence(), this.getLength());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", value=" + Arrays.toString((byte[])this.getPayload()) + "]";
    }

    public ByteArraySection withPayload(byte[] aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public void setPayload(Byte[] aPayload) {
        this.setPayload(ByteArraySection.toPrimitiveArray(aPayload));
    }

    public ByteArraySection withPayload(Byte[] aPayload) {
        this.setPayload(ByteArraySection.toPrimitiveArray(aPayload));
        return this;
    }

    private static byte[] toPrimitiveArray(Byte[] aPayload) {
        byte[] theResult = new byte[aPayload.length];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = aPayload[i];
        }
        return theResult;
    }
}

