/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.refcodes.exception.BugException;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.mixin.TruncateMode;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.Sequence;

public class ByteArraySequence
implements Sequence {
    private byte[][] _chunks;

    public ByteArraySequence() {
        this._chunks = new byte[0][];
    }

    public ByteArraySequence(byte aByte) {
        this._chunks = new byte[1][];
        this._chunks[0] = new byte[]{aByte};
    }

    public ByteArraySequence(byte ... aBytes) {
        this._chunks = new byte[1][];
        this._chunks[0] = aBytes;
    }

    public ByteArraySequence(byte[] ... aBytes) {
        this._chunks = aBytes;
    }

    public ByteArraySequence(byte[] aBytes, int aOffset, int aLength) {
        this._chunks = new byte[1][];
        this._chunks[0] = Arrays.copyOfRange(aBytes, aOffset, aOffset + aLength);
    }

    public ByteArraySequence(byte[][] ... aBytes) {
        int theChunkCount = 0;
        for (int i = 0; i < aBytes.length; ++i) {
            theChunkCount += aBytes[i].length;
        }
        this._chunks = new byte[theChunkCount][];
        int index = 0;
        for (int i = 0; i < aBytes.length; ++i) {
            byte[][] eChunks = aBytes[i];
            for (int j = 0; j < eChunks.length; ++j) {
                this._chunks[index] = eChunks[j];
                ++index;
            }
        }
    }

    public ByteArraySequence(InputStream aInputStream) throws IOException {
        int eByte;
        ByteArrayOutputStream theByteOutputStream = new ByteArrayOutputStream();
        while ((eByte = aInputStream.read()) != -1) {
            theByteOutputStream.write(eByte);
        }
        this._chunks = new byte[1][];
        this._chunks[0] = theByteOutputStream.toByteArray();
    }

    public ByteArraySequence(int aLength) {
        this._chunks = new byte[1][];
        this._chunks[0] = new byte[aLength];
    }

    public ByteArraySequence(Sequence aSequence) {
        this(aSequence.getLength());
        for (int i = 0; i < aSequence.getLength(); ++i) {
            this.setByteAt(i, aSequence.getByteAt(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(byte[] aBytes, int aOffset, int aLength) {
        int i;
        if (aOffset != 0 || aLength != aBytes.length) {
            byte[] theBytes = new byte[aLength];
            for (i = 0; i < theBytes.length; ++i) {
                theBytes[i] = aBytes[aOffset + i];
            }
            aBytes = theBytes;
        }
        byte[][] theChunks = new byte[this._chunks.length + 1][];
        for (i = 0; i < this._chunks.length; ++i) {
            theChunks[i] = this._chunks[i];
        }
        theChunks[theChunks.length - 1] = aBytes;
        this._chunks = theChunks;
        ByteArraySequence byteArraySequence = this;
        synchronized (byteArraySequence) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(Sequence aSequence) {
        if (aSequence != null) {
            this._chunks = ByteArraySequence.toChunks(this._chunks, ByteArraySequence.toChunks(aSequence));
            ByteArraySequence byteArraySequence = this;
            synchronized (byteArraySequence) {
                this.notifyAll();
            }
        }
    }

    @Override
    public void empty() {
        this._chunks = new byte[0][];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArraySequence other = (ByteArraySequence)obj;
        return Arrays.deepEquals((Object[])this._chunks, (Object[])other._chunks);
    }

    @Override
    public byte getByteAt(int aIndex) throws IndexOutOfBoundsException {
        int offset = 0;
        for (int i = 0; i < this._chunks.length; ++i) {
            byte[] eChunk = this._chunks[i];
            if (eChunk.length + offset > aIndex) {
                return eChunk[aIndex - offset];
            }
            offset += eChunk.length;
        }
        throw new IndexOutOfBoundsException(aIndex);
    }

    public int getLength() {
        if (this._chunks == null) {
            return -1;
        }
        int size = 0;
        for (int i = 0; i < this._chunks.length; ++i) {
            size += this._chunks[i].length;
        }
        return size;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode((Object[])this._chunks);
        return result;
    }

    @Override
    public Iterator<Byte> iterator() {
        return new SequenceIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepend(byte[] aBytes, int aOffset, int aLength) {
        int i;
        if (aOffset != 0 && aLength != aBytes.length) {
            byte[] theBytes = new byte[aLength];
            for (i = 0; i < theBytes.length; ++i) {
                theBytes[i] = aBytes[aOffset + i];
            }
            aBytes = theBytes;
        }
        byte[][] theChunks = new byte[this._chunks.length + 1][];
        for (i = 0; i < this._chunks.length; ++i) {
            theChunks[i + 1] = this._chunks[i];
        }
        theChunks[0] = aBytes;
        this._chunks = theChunks;
        ByteArraySequence byteArraySequence = this;
        synchronized (byteArraySequence) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepend(Sequence aSequence) {
        if (aSequence != null) {
            this._chunks = ByteArraySequence.toChunks(ByteArraySequence.toChunks(aSequence), this._chunks);
            ByteArraySequence byteArraySequence = this;
            synchronized (byteArraySequence) {
                this.notifyAll();
            }
        }
    }

    @Override
    public void replace(byte[] aBytes) {
        this._chunks = new byte[1][];
        this._chunks[0] = aBytes;
    }

    @Override
    public void replace(Sequence aSequence) {
        if (aSequence instanceof ByteArraySequence) {
            ByteArraySequence theSequence = (ByteArraySequence)aSequence;
            this._chunks = theSequence._chunks;
        } else {
            this.replace(aSequence.toBytes());
        }
    }

    @Override
    public void replace(byte[] aBytes, int aOffset, int aLength) {
        this._chunks = new byte[1][];
        this._chunks[0] = aOffset == 0 && aLength == aBytes.length ? aBytes : Arrays.copyOfRange(aBytes, aOffset, aOffset + aLength);
    }

    @Override
    public void replace(Sequence aSequence, int aOffset, int aLength) {
        if (aOffset == 0 && aLength == aSequence.getLength()) {
            this.replace(aSequence);
        } else {
            this._chunks = new byte[1][];
            this._chunks[0] = aSequence.toBytes(aOffset, aLength);
        }
    }

    @Override
    public void setByteAt(int aIndex, byte aByte) throws IndexOutOfBoundsException {
        int offset = 0;
        for (int i = 0; i < this._chunks.length; ++i) {
            byte[] eChunk = this._chunks[i];
            if (eChunk.length + offset > aIndex) {
                eChunk[aIndex - offset] = aByte;
                return;
            }
            offset += eChunk.length;
        }
        throw new IndexOutOfBoundsException(aIndex);
    }

    @Override
    public ByteArraySequence toAppend(byte ... aBytes) {
        return this.toAppend(aBytes, 0, aBytes.length);
    }

    @Override
    public ByteArraySequence toAppend(byte[] aBytes, int aOffset, int aLength) {
        byte[] theBytes = new byte[aLength];
        for (int i = 0; i < theBytes.length; ++i) {
            theBytes[i] = aBytes[aOffset + i];
        }
        byte[][] theChunks = new byte[this._chunks.length + 1][];
        for (int i = 0; i < this._chunks.length; ++i) {
            theChunks[i] = (byte[])this._chunks[i].clone();
        }
        theChunks[theChunks.length - 1] = theBytes;
        return new ByteArraySequence((byte[][])theChunks);
    }

    @Override
    public ByteArraySequence toAppend(Sequence aSequence) {
        return ByteArraySequence.toSequence(this, aSequence);
    }

    @Override
    public ByteArraySequence toClone() {
        byte[][] theClone = (byte[][])this._chunks.clone();
        for (int i = 0; i < theClone.length; ++i) {
            theClone[i] = (byte[])theClone[i].clone();
        }
        return new ByteArraySequence(theClone);
    }

    @Override
    public ByteArraySequence toConcatenate(ConcatenateMode aConcatenateMode, byte ... aBytes) {
        switch (aConcatenateMode) {
            case PREPEND: {
                return this.toPrepend(aBytes);
            }
            case APPEND: {
                return this.toAppend(aBytes);
            }
        }
        throw new BugException("Enumeration <" + aConcatenateMode + "> for type <" + ConcatenateMode.class.getName() + "> has by mistaken not been implemented yet!");
    }

    @Override
    public ByteArraySequence toConcatenate(Sequence aSequence, ConcatenateMode aConcatenateMode) {
        switch (aConcatenateMode) {
            case PREPEND: {
                return this.toPrepend(aSequence);
            }
            case APPEND: {
                return this.toAppend(aSequence);
            }
        }
        throw new BugException("Enumeration <" + aConcatenateMode + "> for type <" + ConcatenateMode.class.getName() + "> has by mistaken not been implemented yet!");
    }

    @Override
    public byte[] toCrcBytes(CrcAlgorithm aCrcAlgorithm, Endianess aEndianess) {
        long theChecksum = 0L;
        for (int i = 0; i < this.getChunkCount(); ++i) {
            theChecksum = aCrcAlgorithm.toCrcChecksum(theChecksum, this.getChunkAt(i));
        }
        return aEndianess.toBytes(theChecksum, aCrcAlgorithm.getCrcWidth());
    }

    @Override
    public byte[] toCrcBytes(long aCrcChecksum, CrcAlgorithm aCrcAlgorithm, Endianess aEndianess) {
        for (int i = 0; i < this.getChunkCount(); ++i) {
            aCrcChecksum = aCrcAlgorithm.toCrcChecksum(aCrcChecksum, this.getChunkAt(i));
        }
        return aEndianess.toBytes(aCrcChecksum, aCrcAlgorithm.getCrcWidth());
    }

    @Override
    public long toCrcChecksum(CrcAlgorithm aCrcAlgorithm) {
        long theChecksum = 0L;
        for (int i = 0; i < this.getChunkCount(); ++i) {
            theChecksum = aCrcAlgorithm.toCrcChecksum(theChecksum, this.getChunkAt(i));
        }
        return theChecksum;
    }

    @Override
    public long toCrcChecksum(long aCrcChecksum, CrcAlgorithm aCrcAlgorithm) {
        for (int i = 0; i < this.getChunkCount(); ++i) {
            aCrcChecksum = aCrcAlgorithm.toCrcChecksum(aCrcChecksum, this.getChunkAt(i));
        }
        return aCrcChecksum;
    }

    @Override
    public ByteArraySequence toPrepend(byte ... aBytes) {
        return this.toAppend(aBytes, 0, aBytes.length);
    }

    @Override
    public ByteArraySequence toPrepend(byte[] aBytes, int aOffset, int aLength) {
        byte[] theBytes = new byte[aLength];
        for (int i = 0; i < theBytes.length; ++i) {
            theBytes[i] = aBytes[aOffset + i];
        }
        byte[][] theChunks = new byte[this._chunks.length + 1][];
        for (int i = 0; i < this._chunks.length; ++i) {
            theChunks[i + 1] = (byte[])this._chunks[i].clone();
        }
        theChunks[0] = theBytes;
        return new ByteArraySequence((byte[][])theChunks);
    }

    @Override
    public ByteArraySequence toPrepend(Sequence aSequence) {
        return ByteArraySequence.toSequence(aSequence, this);
    }

    @Override
    public ByteArraySequence toSequence(int aOffset, int aLength) {
        return new ByteArraySequence(this.toBytes(aOffset, aLength));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [length=" + this.getLength() + ", chunks=" + Arrays.toString((Object[])this._chunks) + "]";
    }

    @Override
    public ByteArraySequence toTruncate(int aLength, TruncateMode aTruncateMode) {
        ByteArraySequence theSequence = this.toClone().withTruncate(aLength, aTruncateMode);
        return theSequence;
    }

    @Override
    public ByteArraySequence toTruncateHead(int aLength) {
        ByteArraySequence theSequence = this.toClone().withTruncateHead(aLength);
        return theSequence;
    }

    @Override
    public ByteArraySequence toTruncateTail(int aLength) {
        ByteArraySequence theSequence = this.toClone().withTruncateTail(aLength);
        return theSequence;
    }

    @Override
    public ByteArraySequence toOverwrite(byte[] aBytes) {
        ByteArraySequence theSequence = this.toClone().withOverwrite(aBytes);
        return theSequence;
    }

    @Override
    public ByteArraySequence toOverwrite(int aOffset, Sequence aSeqquence, int aBytesOffset, int aLength) {
        ByteArraySequence theSequence = this.toClone().withOverwrite(aOffset, aSeqquence, aBytesOffset, aLength);
        return theSequence;
    }

    @Override
    public ByteArraySequence toOverwrite(int aOffset, byte[] aBytes, int aBytesOffset, int aLength) {
        ByteArraySequence theSequence = this.toClone().withOverwrite(aOffset, aBytes, aBytesOffset, aLength);
        return theSequence;
    }

    @Override
    public ByteArraySequence toOverwrite(int aOffset, Sequence aSequence) {
        ByteArraySequence theSequence = this.toClone().withOverwrite(aOffset, aSequence);
        return theSequence;
    }

    @Override
    public ByteArraySequence toOverwrite(Sequence aSequence) {
        ByteArraySequence theSequence = this.toClone().withOverwrite(aSequence);
        return theSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateHead(int aLength) {
        if (aLength >= this.getLength()) {
            this._chunks = new byte[0][];
            ByteArraySequence byteArraySequence = this;
            synchronized (byteArraySequence) {
                this.notifyAll();
            }
        }
        if (aLength > 0) {
            int theTruncatedLength = this.getLength() - aLength;
            ArrayList<byte[]> theChunks = new ArrayList<byte[]>();
            int theLength = 0;
            for (int i = this._chunks.length - 1; i > 0 && theLength + this._chunks[i].length <= theTruncatedLength; --i) {
                theChunks.add(0, this._chunks[i]);
                theLength += this._chunks[i].length;
            }
            if (theLength < theTruncatedLength) {
                byte[] theLastChunk = this.toBytes(aLength, theTruncatedLength - theLength);
                theChunks.add(0, theLastChunk);
            }
            this._chunks = (byte[][])theChunks.toArray((T[])new byte[theChunks.size()][]);
            ByteArraySequence byteArraySequence = this;
            synchronized (byteArraySequence) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateTail(int aLength) {
        if (aLength >= this.getLength()) {
            this._chunks = new byte[0][];
            ByteArraySequence byteArraySequence = this;
            synchronized (byteArraySequence) {
                this.notifyAll();
            }
        }
        if (aLength > 0) {
            int theTruncatedLength = this.getLength() - aLength;
            ArrayList<byte[]> theChunks = new ArrayList<byte[]>();
            int theLength = 0;
            for (int i = 0; i < this._chunks.length && theLength + this._chunks[i].length <= theTruncatedLength; ++i) {
                theChunks.add(this._chunks[i]);
                theLength += this._chunks[i].length;
            }
            if (theLength < theTruncatedLength) {
                byte[] theLastChunk = this.toBytes(theLength, theTruncatedLength - theLength);
                theChunks.add(theLastChunk);
            }
            this._chunks = (byte[][])theChunks.toArray((T[])new byte[theChunks.size()][]);
            ByteArraySequence byteArraySequence = this;
            synchronized (byteArraySequence) {
                this.notifyAll();
            }
        }
    }

    @Override
    public ByteArraySequence withAppend(byte ... aBytes) {
        this.append(aBytes);
        return this;
    }

    @Override
    public ByteArraySequence withAppend(byte[] aBytes, int aOffset, int aLength) {
        this.append(aBytes, aOffset, aLength);
        return this;
    }

    @Override
    public ByteArraySequence withAppend(Sequence aSequence) {
        this.append(aSequence);
        return this;
    }

    @Override
    public ByteArraySequence withConcatenate(ConcatenateMode aConcatenateMode, byte ... aBytes) {
        this.concatenate(aConcatenateMode, aBytes);
        return this;
    }

    @Override
    public ByteArraySequence withConcatenate(Sequence aSequence, ConcatenateMode aConcatenateMode) {
        this.prepend(aSequence);
        return this;
    }

    @Override
    public ByteArraySequence withPrepend(byte ... aBytes) {
        this.prepend(aBytes);
        return this;
    }

    @Override
    public ByteArraySequence withPrepend(byte[] aBytes, int aOffset, int aLength) {
        this.prepend(aBytes, aOffset, aLength);
        return this;
    }

    @Override
    public ByteArraySequence withPrepend(Sequence aSequence) {
        this.prepend(aSequence);
        return this;
    }

    @Override
    public ByteArraySequence withReplace(byte[] aBytes) {
        this.replace(aBytes);
        return this;
    }

    @Override
    public ByteArraySequence withReplace(byte[] aBytes, int aOffset, int aLength) {
        this.replace(aBytes, aOffset, aLength);
        return this;
    }

    @Override
    public ByteArraySequence withReplace(Sequence aSequence) {
        this.replace(aSequence);
        return this;
    }

    @Override
    public ByteArraySequence withReplace(Sequence aSequence, int aOffset, int aLength) {
        this.replace(aSequence, aOffset, aLength);
        return this;
    }

    @Override
    public ByteArraySequence withTruncate(int aLength, TruncateMode aTruncateMode) {
        this.truncate(aLength, aTruncateMode);
        return this;
    }

    @Override
    public ByteArraySequence withTruncateHead(int aLength) {
        this.truncateHead(aLength);
        return this;
    }

    @Override
    public ByteArraySequence withTruncateTail(int aLength) {
        this.truncateTail(aLength);
        return this;
    }

    @Override
    public ByteArraySequence withOverwrite(byte[] aBytes) {
        this.overwrite(aBytes);
        return this;
    }

    @Override
    public ByteArraySequence withOverwrite(int aOffset, byte[] aBytes) {
        this.overwrite(aOffset, aBytes);
        return this;
    }

    @Override
    public ByteArraySequence withOverwrite(int aOffset, byte[] aBytes, int aBytesOffset, int aLength) {
        this.overwrite(aOffset, aBytes, aBytesOffset, aLength);
        return this;
    }

    @Override
    public ByteArraySequence withOverwrite(int aOffset, Sequence aSequence) {
        this.overwrite(aOffset, aSequence);
        return this;
    }

    @Override
    public ByteArraySequence withOverwrite(int aOffset, Sequence aSequence, int aSequenceOffset, int aLength) {
        this.overwrite(aOffset, aSequence, aSequenceOffset, aLength);
        return this;
    }

    @Override
    public ByteArraySequence withOverwrite(Sequence aSequence) {
        this.overwrite(aSequence);
        return this;
    }

    @Override
    public void writeTo(OutputStream aOutputStream) throws IOException {
        for (byte[] aChunk : this._chunks) {
            aOutputStream.write(aChunk);
        }
    }

    byte[] getChunkAt(int aIndex) throws IndexOutOfBoundsException {
        return this._chunks[aIndex];
    }

    int getChunkCount() {
        return this._chunks.length;
    }

    byte[][] getChunks() {
        return this._chunks;
    }

    private static byte[][] toChunks(byte[][] ... aBytes) {
        int length = 0;
        for (int i = 0; i < aBytes.length; ++i) {
            length += aBytes[i].length;
        }
        byte[][] theChunks = new byte[length][];
        int index = 0;
        for (int i = 0; i < aBytes.length; ++i) {
            byte[][] eChunks = aBytes[i];
            for (int j = 0; j < eChunks.length; ++j) {
                theChunks[index] = eChunks[j];
                ++index;
            }
        }
        return theChunks;
    }

    private static byte[][] toChunks(Sequence aSequence) {
        if (aSequence instanceof ByteArraySequence) {
            return ((ByteArraySequence)aSequence).getChunks();
        }
        return new byte[][]{aSequence.toBytes()};
    }

    private static Sequence[] toNormalized(Sequence[] aSequences) {
        ArrayList<Sequence> theSequences = new ArrayList<Sequence>();
        for (int i = 0; i < aSequences.length; ++i) {
            if (aSequences[i] == null) continue;
            theSequences.add(aSequences[i]);
        }
        return theSequences.toArray(new ByteArraySequence[theSequences.size()]);
    }

    private static ByteArraySequence toSequence(Sequence ... aSequences) {
        ByteArraySequence eChunkSequence;
        aSequences = ByteArraySequence.toNormalized(aSequences);
        int length = 0;
        for (int i = 0; i < aSequences.length; ++i) {
            if (aSequences[i] instanceof ByteArraySequence) {
                eChunkSequence = (ByteArraySequence)aSequences[i];
                length += eChunkSequence._chunks.length;
                continue;
            }
            ++length;
        }
        byte[][] theChunks = new byte[length][];
        int index = 0;
        for (int i = 0; i < aSequences.length; ++i) {
            if (aSequences[i] instanceof ByteArraySequence) {
                eChunkSequence = (ByteArraySequence)aSequences[i];
                for (int j = 0; j < eChunkSequence.getChunkCount(); ++j) {
                    theChunks[index] = (byte[])eChunkSequence._chunks[j].clone();
                    ++index;
                }
                continue;
            }
            theChunks[index] = aSequences[i].toBytes();
            ++index;
        }
        return new ByteArraySequence((byte[][])theChunks);
    }

    public class SequenceIterator
    implements Iterator<Byte> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < ByteArraySequence.this.getLength();
        }

        @Override
        public Byte next() {
            return ByteArraySequence.this.getByteAt(this.index++);
        }
    }
}

