/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.mixin.TypeAccessor;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractPayloadSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.textual.CaseStyleBuilder;

public class EnumSegment<E extends Enum<E>>
extends AbstractPayloadSegment<Enum<E>>
implements Segment,
TypeAccessor<E> {
    private static final long serialVersionUID = 1L;
    public static final String ENDIANESS = "ENDIANESS";
    public static final int BYTES = 4;
    private Endianess _endianess;
    private Class<E> _type;

    public EnumSegment(Class<E> aType, TransmissionMetrics aTransmissionMetrics) {
        this(aType, aTransmissionMetrics.getEndianess());
    }

    public EnumSegment(Enum<E> aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aValue, aTransmissionMetrics.getEndianess());
    }

    public EnumSegment(String aAlias, Class<E> aType, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aType, aTransmissionMetrics.getEndianess());
    }

    public EnumSegment(String aAlias, Enum<E> aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aValue, aTransmissionMetrics.getEndianess());
    }

    public EnumSegment(Class<E> aType) {
        this(CaseStyleBuilder.asCamelCase((String)EnumSegment.class.getSimpleName()), aType);
    }

    public EnumSegment(Class<E> aType, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)EnumSegment.class.getSimpleName()), aType, aEndianess);
    }

    public EnumSegment(Enum<E> aValue, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)EnumSegment.class.getSimpleName()), aValue, aEndianess);
    }

    public EnumSegment(String aAlias, Class<E> aType) {
        this(aAlias, aType, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public EnumSegment(String aAlias, Class<E> aType, Endianess aEndianess) {
        super(aAlias, null);
        this._endianess = aEndianess;
        this._type = aType;
    }

    public EnumSegment(String aAlias, Enum<E> aValue, Endianess aEndianess) {
        super(aAlias, aValue);
        this._endianess = aEndianess;
        this._type = aValue.getClass();
    }

    public EnumSegment(String aAlias, Class<E> aType, Enum<E> aValue, Endianess aEndianess) {
        super(aAlias, aValue);
        this._endianess = aEndianess;
        this._type = aType;
        if (this._type == null && aValue != null) {
            this._type = aValue.getClass();
        }
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence(this._endianess.toBytes(this.getPayload() != null ? ((Enum)this.getPayload()).ordinal() : 0, 4));
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        byte[] theRecord = aSequence.toBytes(aOffset, 4);
        this.setPayload(((Enum[])this._type.getEnumConstants())[this._endianess.toInteger(theRecord)]);
        return aOffset + 4;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getClass(), "A body containing an enumeration payload.", this.getAlias(), this.toSequence(), "" + this.getPayload(), this.getLength());
        theSchema.put(ENDIANESS, this._endianess);
        return theSchema;
    }

    public EnumSegment<E> withPayload(Enum<E> aValue) {
        this.setPayload(aValue);
        return this;
    }

    public Class<E> getType() {
        return this._type;
    }
}

