/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.PayloadSegment;
import org.refcodes.serial.PayloadTransmission;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionSequenceException;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapBuilderImpl;
import org.refcodes.textual.CaseStyleBuilder;

public class FixedLengthSequenceSegment
implements PayloadSegment<Sequence>,
Segment.SegmentMixin {
    private static final long serialVersionUID = 1L;
    protected Sequence _sequence;
    protected String _alias;

    public FixedLengthSequenceSegment(int aSequenceSize) {
        this(CaseStyleBuilder.asCamelCase((String)FixedLengthSequenceSegment.class.getSimpleName()), aSequenceSize);
    }

    public FixedLengthSequenceSegment(String aAlias, int aSequenceSize) {
        this(aAlias, new ByteArraySequence(aSequenceSize));
    }

    public FixedLengthSequenceSegment(Sequence aSequence) {
        this(CaseStyleBuilder.asCamelCase((String)FixedLengthSequenceSegment.class.getSimpleName()), aSequence);
    }

    public FixedLengthSequenceSegment(String aAlias, Sequence aSequence) {
        this._alias = aAlias;
        this._sequence = aSequence;
    }

    @Override
    public int getLength() {
        return this._sequence.getLength();
    }

    @Override
    public Sequence toSequence() {
        return this._sequence;
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        if (aSequence.getLength() < aOffset + this._sequence.getLength()) {
            throw new TransmissionSequenceException(aSequence, "The provided sequence length <" + aSequence.getLength() + "> is not sufficient to retrieve a sequence with length <" + this._sequence.getLength() + "> at offset <" + aOffset + ">!");
        }
        this._sequence.replace(aSequence.toSequence(aOffset, this._sequence.getLength()));
        return aOffset + this._sequence.getLength();
    }

    @Override
    public SerialSchema toSchema() {
        return new SerialSchema(this.getClass(), "A segment consisting of a sequence.", this.getAlias(), this.toSequence(), this.getLength());
    }

    public String getAlias() {
        return this._alias;
    }

    public PayloadTransmission<Sequence> withPayload(Sequence aValue) {
        this.setPayload(aValue);
        return this;
    }

    public Sequence getPayload() {
        return this._sequence;
    }

    public void setPayload(Sequence aValue) {
        this._sequence = aValue;
    }

    @Override
    public SimpleTypeMap toSimpleTypeMap() {
        return new SimpleTypeMapBuilderImpl().withPut(this._alias, this._sequence != null ? this._sequence.toBytes() : null);
    }
}

