/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.lang.reflect.Array;
import java.util.Collection;
import org.refcodes.factory.TypeFactory;
import org.refcodes.serial.AbstractArrayTransmission;
import org.refcodes.serial.ArraySection;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionSequenceException;

public class FixedSegmentArraySection<ARRAY extends Segment>
extends AbstractArrayTransmission<ARRAY>
implements ArraySection<ARRAY> {
    private static final long serialVersionUID = 1L;

    public FixedSegmentArraySection(Class<ARRAY> aSegmentClass) {
        super(aSegmentClass);
    }

    public FixedSegmentArraySection(Collection<ARRAY> aSegments) {
        super(aSegments);
    }

    @SafeVarargs
    public FixedSegmentArraySection(ARRAY ... aSegments) {
        super(aSegments);
    }

    public FixedSegmentArraySection(String aAlias, Class<ARRAY> aSegmentClass) {
        super(aAlias, aSegmentClass);
    }

    public FixedSegmentArraySection(String aAlias, Collection<ARRAY> aSegments) {
        super(aAlias, aSegments);
    }

    @SafeVarargs
    public FixedSegmentArraySection(String aAlias, ARRAY ... aSegments) {
        super(aAlias, aSegments);
    }

    public FixedSegmentArraySection(String aAlias, TypeFactory<ARRAY> aSegmentFactory, Collection<ARRAY> aSegments) {
        super(aAlias, aSegmentFactory, aSegments);
    }

    @SafeVarargs
    public FixedSegmentArraySection(String aAlias, TypeFactory<ARRAY> aSegmentFactory, ARRAY ... aSegments) {
        super(aAlias, aSegmentFactory, aSegments);
    }

    public FixedSegmentArraySection(String aAlias, TypeFactory<ARRAY> aSegmentFactory) {
        super(aAlias, aSegmentFactory);
    }

    public FixedSegmentArraySection(TypeFactory<ARRAY> aSegmentFactory, Collection<ARRAY> aSegments) {
        super(aSegmentFactory, aSegments);
    }

    @SafeVarargs
    public FixedSegmentArraySection(TypeFactory<ARRAY> aSegmentFactory, ARRAY ... aSegments) {
        super(aSegmentFactory, aSegments);
    }

    public FixedSegmentArraySection(TypeFactory<ARRAY> aSegmentFactory) {
        super(aSegmentFactory);
    }

    @Override
    public FixedSegmentArraySection<ARRAY> withArray(ARRAY[] aValue) {
        this.setArray((Transmission[])aValue);
        return this;
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        if (aLength != 0) {
            Segment theFirst = (Segment)this._sequenceableFactory.createInstance();
            int theFixedLength = theFirst.getLength();
            if (aLength % theFixedLength != 0) {
                throw new TransmissionSequenceException(aSequence, "The length dedicated <" + aLength + "> does not match a multiple element's length <" + theFixedLength + "> for retrieving an array from the given sequence at the offset <" + aOffset + ">!");
            }
            int theLength = aLength / theFixedLength;
            if (theLength != 0) {
                this._array = (Segment[])Array.newInstance(theFirst.getClass(), theLength);
                ((Segment[])this._array)[0] = theFirst;
                ((Segment[])this._array)[0].fromTransmission(aSequence, aOffset + 0 * theFixedLength);
                for (int i = 1; i < ((Segment[])this._array).length; ++i) {
                    ((Segment[])this._array)[i] = (Segment)this._sequenceableFactory.createInstance();
                    ((Segment[])this._array)[i].fromTransmission(aSequence, aOffset + i * theFixedLength);
                }
            }
        }
    }
}

