/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.util.Arrays;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractPayloadSection;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.PayloadSection;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.TransmissionSequenceException;
import org.refcodes.textual.CaseStyleBuilder;

public class IntArraySection
extends AbstractPayloadSection<int[]>
implements PayloadSection<int[]> {
    private static final long serialVersionUID = 1L;
    public static final String ENDIANESS = "ENDIANESS";
    private Endianess _endianess;

    public IntArraySection(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEndianess());
    }

    public IntArraySection(TransmissionMetrics aTransmissionMetrics, int ... aValue) {
        this(aTransmissionMetrics.getEndianess(), aValue);
    }

    public IntArraySection(TransmissionMetrics aTransmissionMetrics, Integer ... aValue) {
        this(aTransmissionMetrics.getEndianess(), aValue);
    }

    public IntArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getEndianess());
    }

    public IntArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics, int ... aValue) {
        this(aAlias, aTransmissionMetrics.getEndianess(), aValue);
    }

    public IntArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics, Integer ... aValue) {
        this(aAlias, aTransmissionMetrics.getEndianess(), aValue);
    }

    public IntArraySection() {
        this(CaseStyleBuilder.asCamelCase((String)IntArraySection.class.getSimpleName()), new int[0]);
    }

    public IntArraySection(Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)IntArraySection.class.getSimpleName()), aEndianess, new int[0]);
    }

    public IntArraySection(int ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)IntArraySection.class.getSimpleName()), aValue);
    }

    public IntArraySection(Integer ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)IntArraySection.class.getSimpleName()), aValue);
    }

    public IntArraySection(Endianess aEndianess, int ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)IntArraySection.class.getSimpleName()), aEndianess, aValue);
    }

    public IntArraySection(Endianess aEndianess, Integer ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)IntArraySection.class.getSimpleName()), aEndianess, IntArraySection.toPrimitiveArray(aValue));
        this._endianess = aEndianess;
    }

    public IntArraySection(String aAlias) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, new int[0]);
    }

    public IntArraySection(String aAlias, Endianess aEndianess) {
        this(aAlias, aEndianess, new int[0]);
    }

    public IntArraySection(String aAlias, int ... aValue) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, aValue);
    }

    public IntArraySection(String aAlias, Integer ... aValue) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, aValue);
    }

    public IntArraySection(String aAlias, Endianess aEndianess, int ... aValue) {
        super(aAlias, aValue);
        this._endianess = aEndianess;
    }

    public IntArraySection(String aAlias, Endianess aEndianess, Integer ... aValue) {
        super(aAlias, IntArraySection.toPrimitiveArray(aValue));
        this._endianess = aEndianess;
    }

    @Override
    public Sequence toSequence() {
        byte[] theBytes = new byte[((int[])this.getPayload()).length * 4];
        for (int i = 0; i < ((int[])this.getPayload()).length; ++i) {
            byte[] eRecord = this._endianess.toBytes(((int[])this.getPayload())[i], 4);
            for (int j = 0; j < eRecord.length; ++j) {
                theBytes[i * 4 + j] = eRecord[j];
            }
        }
        return new ByteArraySequence(theBytes);
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        if (aLength % 4 != 0) {
            throw new TransmissionSequenceException(aSequence, "The length dedicated <" + aLength + "> does not match a multiple integer length <4> for retrieving an integer array from the given sequence at the offset <" + aOffset + ">!");
        }
        int[] theInts = new int[aLength / 4];
        for (int i = 0; i < theInts.length; ++i) {
            byte[] eRecord = aSequence.toBytes(aOffset + i * 4, 4);
            theInts[i] = this._endianess.toInteger(eRecord);
        }
        this.setPayload(theInts);
    }

    @Override
    public int getLength() {
        return this.getPayload() != null ? ((int[])this.getPayload()).length * 4 : 0;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getClass(), "A body containing an integer payload.", this.getAlias(), this.toSequence(), this.getLength());
        theSchema.put(ENDIANESS, this._endianess);
        return theSchema;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", value=" + Arrays.toString((int[])this.getPayload()) + "]";
    }

    public IntArraySection withPayload(int[] aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public void setPayload(Integer[] aPayload) {
        this.setPayload(IntArraySection.toPrimitiveArray(aPayload));
    }

    public IntArraySection withPayload(Integer[] aPayload) {
        this.setPayload(IntArraySection.toPrimitiveArray(aPayload));
        return this;
    }

    private static int[] toPrimitiveArray(Integer[] aPayload) {
        int[] theResult = new int[aPayload.length];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = aPayload[i];
        }
        return theResult;
    }
}

