/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.refcodes.serial.AbstractMagicBytesTransmissionDecorator;
import org.refcodes.serial.DecoratorSegment;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.textual.CaseStyleBuilder;

public class MagicBytesSegmentDecorator<DECORATEE extends Segment>
extends AbstractMagicBytesTransmissionDecorator<DECORATEE>
implements Segment.SegmentMixin,
DecoratorSegment<DECORATEE> {
    private static final long serialVersionUID = 1L;

    public MagicBytesSegmentDecorator(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        super(CaseStyleBuilder.asCamelCase((String)MagicBytesSegmentDecorator.class.getSimpleName()), aDecoratee, aTransmissionMetrics);
    }

    public MagicBytesSegmentDecorator(String aAlias, DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        super(aAlias, aDecoratee, aTransmissionMetrics);
    }

    public MagicBytesSegmentDecorator(DECORATEE aDecoratee, int aMagicBytesLength) {
        this(CaseStyleBuilder.asCamelCase((String)MagicBytesSegmentDecorator.class.getSimpleName()), aDecoratee, aMagicBytesLength);
    }

    public MagicBytesSegmentDecorator(DECORATEE aDecoratee, String aMagicBytes) {
        this(CaseStyleBuilder.asCamelCase((String)MagicBytesSegmentDecorator.class.getSimpleName()), aDecoratee, aMagicBytes);
    }

    public MagicBytesSegmentDecorator(DECORATEE aDecoratee, String aMagicBytes, Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase((String)MagicBytesSegmentDecorator.class.getSimpleName()), aDecoratee, aMagicBytes);
    }

    public MagicBytesSegmentDecorator(DECORATEE aDecoratee, byte ... aMagicBytes) {
        this(CaseStyleBuilder.asCamelCase((String)MagicBytesSegmentDecorator.class.getSimpleName()), aDecoratee, aMagicBytes);
    }

    public MagicBytesSegmentDecorator(String aAlias, DECORATEE aDecoratee, int aMagicBytesLength) {
        super(aAlias, aDecoratee, aMagicBytesLength);
    }

    public MagicBytesSegmentDecorator(String aAlias, DECORATEE aDecoratee, String aMagicBytes) {
        super(aAlias, aDecoratee, aMagicBytes);
    }

    public MagicBytesSegmentDecorator(String aAlias, DECORATEE aDecoratee, String aMagicBytes, Charset aCharset) {
        super(aAlias, aDecoratee, aMagicBytes);
    }

    public MagicBytesSegmentDecorator(String aAlias, DECORATEE aDecoratee, byte ... aMagicBytes) {
        super(aAlias, aDecoratee, aMagicBytes);
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        this._magicBytes = aSequence.toBytes(aOffset, this._magicBytesLength);
        aOffset += this._magicBytesLength;
        aOffset = ((Segment)this.getDecoratee()).fromTransmission(aSequence, aOffset);
        return aOffset;
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException, TransmissionException {
        this._magicBytes = this._magicBytes != null && this._magicBytes.length != this._magicBytesLength ? new byte[this._magicBytesLength] : this._magicBytes;
        aInputStream.read(this._magicBytes);
        ((Segment)this.getDecoratee()).receiveFrom(aInputStream, aReturnStream);
    }

    public MagicBytesSegmentDecorator<DECORATEE> withPayload(byte[] aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getClass(), "A segment decorator prefixing the encapsulated segment with magic bytes.", this.getAlias(), this.toSequence(), this.getLength(), ((Segment)this._decoratee).toSchema());
        theSchema.put("MAGIC_BYTES", this.getMagicBytes());
        theSchema.put("MAGIC_BYTES_TEXT", this.toMagicBytesString());
        return theSchema;
    }
}

