/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import org.refcodes.exception.BugException;
import org.refcodes.mixin.BlockSizeAccessor;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.mixin.InputStreamAccessor;
import org.refcodes.mixin.PacketSizeAccessor;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.ChecksumValidationModeAccessor;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmAccessor;
import org.refcodes.numerical.CrcChecksumConcatenateModeAccessor;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.EndianessAccessor;
import org.refcodes.serial.AllocSectionDecoratorSegment;
import org.refcodes.serial.BoundedSequenceDecorator;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.CrcSegmentPackager;
import org.refcodes.serial.MagicBytesSegment;
import org.refcodes.serial.NumberSegment;
import org.refcodes.serial.PacketLengthWidthAccessor;
import org.refcodes.serial.PacketMagicBytesAccessor;
import org.refcodes.serial.PacketOutputStream;
import org.refcodes.serial.PacketSegmentPackagerAccessor;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentComposite;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceNumberAccessor;
import org.refcodes.serial.SequenceNumberConcatenateModeAccessor;
import org.refcodes.serial.SequenceNumberInitValueAccessor;
import org.refcodes.serial.SequenceNumberWidthAccessor;
import org.refcodes.serial.SequenceSection;
import org.refcodes.serial.TransmissionMetrics;

public class PacketInputStream
extends InputStream
implements PacketLengthWidthAccessor,
EndianessAccessor,
BlockSizeAccessor,
SequenceNumberAccessor,
SequenceNumberWidthAccessor,
SequenceNumberInitValueAccessor,
SequenceNumberConcatenateModeAccessor,
PacketSizeAccessor,
PacketSegmentPackagerAccessor,
PacketMagicBytesAccessor {
    private Sequence _blockSequence;
    private int _blockSize;
    private Endianess _endianess;
    private boolean _isClosed;
    private int _packetLength;
    private byte[] _packetMagicBytes;
    private SegmentPackager _packetSegmentPackager;
    private ConcatenateMode _sequenceNumberConcatenateMode;
    private int _sequenceNumberWidth;
    private int _packetLengthWidth;
    protected int _blockOffset;
    protected InputStream _inputStream;
    protected Segment _packetSegment;
    protected int _sequenceNumber;
    protected int _sequenceNumberInitValue;
    protected NumberSegment _sequenceNumberSegment;
    protected AllocSectionDecoratorSegment<SequenceSection> _allocSegment;
    protected BoundedSequenceDecorator _boundedSequence;

    public static Builder builder() {
        return new Builder();
    }

    private PacketInputStream(Builder aBuilder) {
        this(aBuilder.inputStream, aBuilder.blockSize, aBuilder.truncateLengthWidth, aBuilder.packetMagicBytes, aBuilder.sequenceNumberInitValue, aBuilder.sequenceNumberWidth, aBuilder.sequenceNumberConcatenateMode, aBuilder.toPacketSegmentPackager(), aBuilder.endianess);
    }

    public PacketInputStream(InputStream aInputStream, TransmissionMetrics aTransmissionMetrics) {
        this(aInputStream, aTransmissionMetrics.getBlockSize(), aTransmissionMetrics.getPacketLengthWidth(), aTransmissionMetrics.getPacketMagicBytes(), aTransmissionMetrics.getSequenceNumberInitValue(), aTransmissionMetrics.getSequenceNumberWidth(), aTransmissionMetrics.getSequenceNumberConcatenateMode(), aTransmissionMetrics.toPacketSegmentPackager(), aTransmissionMetrics.getEndianess());
    }

    public PacketInputStream(InputStream aInputStream, int aBlockSize, int aPacketLengthWidth, byte[] aPacketMagicBytes, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, SegmentPackager aPacketSegmentPackager, Endianess aEndianess) {
        this._inputStream = aInputStream;
        this._packetMagicBytes = aPacketMagicBytes;
        this._sequenceNumberConcatenateMode = aSequenceNumberConcatenateMode;
        this._sequenceNumberInitValue = aSequenceNumberInitValue;
        this._sequenceNumberWidth = aSequenceNumberWidth;
        this._sequenceNumber = aSequenceNumberInitValue != -1 ? aSequenceNumberInitValue : 0;
        this._blockSize = aBlockSize;
        this._packetLengthWidth = aPacketLengthWidth;
        this._endianess = aEndianess;
        this._packetSegmentPackager = aPacketSegmentPackager != null ? aPacketSegmentPackager : new SegmentPackager.DummySegmentPackager();
        this._blockSequence = new ByteArraySequence(aBlockSize);
        this._boundedSequence = new BoundedSequenceDecorator(this._blockSequence, aBlockSize);
        this._sequenceNumberSegment = new NumberSegment(aSequenceNumberWidth, Long.valueOf(aSequenceNumberInitValue), aEndianess);
        this._blockOffset = aBlockSize;
        AllocSectionDecoratorSegment<SequenceSection> theAllocSegment = new AllocSectionDecoratorSegment<SequenceSection>(new SequenceSection(this._boundedSequence), aPacketLengthWidth, aEndianess);
        this._allocSegment = theAllocSegment;
        MagicBytesSegment theMagicBytes = new MagicBytesSegment(aPacketMagicBytes);
        this._packetSegment = this._packetSegmentPackager.toPackaged(switch (this._sequenceNumberConcatenateMode) {
            case ConcatenateMode.APPEND -> new SegmentComposite(new Segment[]{theMagicBytes, theAllocSegment, this._sequenceNumberSegment});
            case ConcatenateMode.PREPEND -> new SegmentComposite(new Segment[]{theMagicBytes, this._sequenceNumberSegment, theAllocSegment});
            default -> throw new BugException("The enumeration <" + this._sequenceNumberConcatenateMode + "> has been forgotten to get implemented.");
        });
        this._packetLength = this._packetSegment.getLength();
    }

    @Override
    public int available() throws IOException {
        if (this._isClosed) {
            throw new IOException("The stream has already been closed!");
        }
        int theAvaialbel = super.available();
        int theBlocks = theAvaialbel % this._packetLength;
        int theBlocksSize = theBlocks * this._blockSize;
        int theLastBlockSize = theAvaialbel - theBlocks * this._packetLength;
        int thePackageOverhead = this._packetSegment.getLength() - this._blockSize - this._sequenceNumberWidth;
        if (theLastBlockSize >= this._sequenceNumberWidth + thePackageOverhead) {
            theLastBlockSize = theLastBlockSize - this._sequenceNumberWidth - thePackageOverhead;
        }
        return theBlocksSize + theLastBlockSize;
    }

    @Override
    public void close() throws IOException {
        this._isClosed = true;
        super.close();
    }

    public int getBlockSize() {
        return this._blockSize;
    }

    public Endianess getEndianess() {
        return this._endianess;
    }

    @Override
    public byte[] getPacketMagicBytes() {
        return this._packetMagicBytes;
    }

    @Override
    public SegmentPackager getPacketSegmentPackager() {
        return this._packetSegmentPackager;
    }

    public int getPacketSize() {
        return this._packetLength;
    }

    @Override
    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    @Override
    public ConcatenateMode getSequenceNumberConcatenateMode() {
        return this._sequenceNumberConcatenateMode;
    }

    @Override
    public int getSequenceNumberInitValue() {
        return this._sequenceNumberInitValue;
    }

    @Override
    public int getSequenceNumberWidth() {
        return this._sequenceNumberWidth;
    }

    @Override
    public int getPacketLengthWidth() {
        return this._packetLengthWidth;
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("A stream of type <" + this.getClass().getName() + "> does not support this operation!");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this._isClosed) {
            return -1;
        }
        if (this._blockOffset == this._blockSize) {
            int theAvailable = this._inputStream.available();
            try {
                this.doReceivePacket();
                this._blockOffset = 0;
            }
            catch (IOException e) {
                if (theAvailable == 0) {
                    return -1;
                }
                throw e;
            }
        }
        return this._blockOffset >= this._allocSegment.getAllocLength() ? -1 : this._blockSequence.getByteAt(this._blockOffset++) & 0xFF;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("A stream of type <" + this.getClass().getName() + "> does not support this operation!");
    }

    protected void doReceivePacket() throws IOException {
        this._packetSegment.receiveFrom(this._inputStream);
        this._sequenceNumber = ((Long)this._sequenceNumberSegment.getPayload()).intValue();
        this._blockOffset = 0;
    }

    static SegmentPackager toPacketSegmentPackager(CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        if (aCrcAlgorithm != null || aChecksumValidationMode != null || aCrcChecksumConcatenateMode != null) {
            CrcAlgorithm theCrcAlgorithm = aCrcAlgorithm != null ? aCrcAlgorithm : TransmissionMetrics.DEFAULT_CRC_ALGORITHM;
            ChecksumValidationMode theCrcChecksumValidationMode = aChecksumValidationMode != null ? aChecksumValidationMode : TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE;
            ConcatenateMode theCrcChecksumConcatenateMode = aCrcChecksumConcatenateMode != null ? aCrcChecksumConcatenateMode : TransmissionMetrics.DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE;
            Endianess theEndianess = aEndianess != null ? aEndianess : TransmissionMetrics.DEFAULT_ENDIANESS;
            return new CrcSegmentPackager(theCrcAlgorithm, theCrcChecksumConcatenateMode, theCrcChecksumValidationMode, theEndianess);
        }
        return new SegmentPackager.DummySegmentPackager();
    }

    public static class Builder
    implements SequenceNumberInitValueAccessor.SequenceNumberInitValueBuilder<Builder>,
    SequenceNumberWidthAccessor.SequenceNumberWidthBuilder<Builder>,
    BlockSizeAccessor.BlockSizeBuilder<Builder>,
    InputStreamAccessor.InputStreamBuilder<Builder>,
    EndianessAccessor.EndianessBuilder<Builder>,
    SequenceNumberConcatenateModeAccessor.SequenceNumberConcatenateModeBuilder<Builder>,
    PacketSegmentPackagerAccessor.PacketSegmentPackagerBuilder<Builder>,
    CrcAlgorithmAccessor.CrcAlgorithmBuilder<Builder>,
    ChecksumValidationModeAccessor.ChecksumValidationModeBuilder<Builder>,
    CrcChecksumConcatenateModeAccessor.CrcChecksumConcatenateModeBuilder<Builder>,
    PacketLengthWidthAccessor.PacketLengthWidthBuilder<Builder>,
    PacketMagicBytesAccessor.PacketMagicBytesBuilder<Builder> {
        int blockSize = 1024;
        CrcAlgorithm crcAlgorithm = null;
        ConcatenateMode crcChecksumConcatenateMode = null;
        ChecksumValidationMode crcChecksumValidationMode = null;
        Endianess endianess = TransmissionMetrics.DEFAULT_ENDIANESS;
        InputStream inputStream = null;
        byte[] packetMagicBytes = TransmissionMetrics.DEFAULT_PACKET_MAGIC_BYTES;
        SegmentPackager packetSegmentPackager = null;
        ConcatenateMode sequenceNumberConcatenateMode = TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE;
        int sequenceNumberInitValue = -1;
        int sequenceNumberWidth = 4;
        int truncateLengthWidth = 4;

        Builder() {
        }

        public PacketInputStream build() {
            return new PacketInputStream(this);
        }

        public Builder withBlockSize(int aBlockSize) {
            this.blockSize = aBlockSize;
            return this;
        }

        public Builder withCrcAlgorithm(CrcAlgorithm aCrcAlgorithm) {
            this.crcAlgorithm = aCrcAlgorithm;
            return this;
        }

        public Builder withCrcChecksumConcatenateMode(ConcatenateMode aCrcChecksumConcatenateMode) {
            this.crcChecksumConcatenateMode = aCrcChecksumConcatenateMode;
            return this;
        }

        public Builder withChecksumValidationMode(ChecksumValidationMode aChecksumValidationMode) {
            this.crcChecksumValidationMode = aChecksumValidationMode;
            return this;
        }

        public Builder withEndianess(Endianess aEndianess) {
            this.endianess = aEndianess;
            return this;
        }

        public Builder withInputStream(InputStream aInputStream) {
            this.inputStream = aInputStream;
            return this;
        }

        @Override
        public Builder withPacketMagicBytes(byte[] aPacketMagicBytes) {
            this.packetMagicBytes = aPacketMagicBytes;
            return this;
        }

        @Override
        public Builder withPacketSegmentPackager(SegmentPackager aPacketSegmentPackager) {
            this.packetSegmentPackager = aPacketSegmentPackager;
            return this;
        }

        @Override
        public Builder withSequenceNumberConcatenateMode(ConcatenateMode aSequenceNumberConcatenateMode) {
            this.sequenceNumberConcatenateMode = aSequenceNumberConcatenateMode;
            return this;
        }

        @Override
        public Builder withSequenceNumberInitValue(int aSequenceNumberInitValue) {
            this.sequenceNumberInitValue = aSequenceNumberInitValue;
            return this;
        }

        @Override
        public Builder withSequenceNumberWidth(int aSequenceNumberWidth) {
            this.sequenceNumberWidth = aSequenceNumberWidth;
            return this;
        }

        @Override
        public Builder withPacketLengthWidth(int aPacketLengthWidth) {
            this.truncateLengthWidth = aPacketLengthWidth;
            return this;
        }

        SegmentPackager toPacketSegmentPackager() {
            if (this.packetSegmentPackager != null) {
                return this.packetSegmentPackager;
            }
            return PacketOutputStream.toPacketSegmentPackager(this.crcAlgorithm, this.crcChecksumConcatenateMode, this.crcChecksumValidationMode, this.endianess);
        }
    }
}

