/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.IoTimeout;
import org.refcodes.io.SkipAvailableInputStream;
import org.refcodes.io.TimeoutInputStream;
import org.refcodes.mixin.DecorateeAccessor;
import org.refcodes.serial.AbstractReadyToReceiveTransmissionDecorator;
import org.refcodes.serial.DecoratorSection;
import org.refcodes.serial.EnquiryStandbyTimeMillisAccessor;
import org.refcodes.serial.FlowControlRetryException;
import org.refcodes.serial.ReadyToReceiveMagicBytesAccessor;
import org.refcodes.serial.ReadyToReceiveRetryNumberAccessor;
import org.refcodes.serial.ReadyToReceiveSegmentPackagerAccessor;
import org.refcodes.serial.ReadyToReceiveTimeoutMillisAccessor;
import org.refcodes.serial.ReadyToReceiveTransmission;
import org.refcodes.serial.Section;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;

public class ReadyToReceiveSectionDecorator<DECORATEE extends Section>
extends AbstractReadyToReceiveTransmissionDecorator<DECORATEE>
implements ReadyToReceiveTransmission,
Section,
DecoratorSection<DECORATEE> {
    private static final long serialVersionUID = 1L;

    private ReadyToReceiveSectionDecorator(Builder<DECORATEE> aBuilder) {
        this(aBuilder.decoratee, aBuilder.enquiryStandbyTimeInMs, aBuilder.readyToReceiveMagicBytes, aBuilder.readyToReceiveRetryNumber, aBuilder.readyToReceiveTimeoutInMs, aBuilder.readyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee) {
        super(aDecoratee);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aReadyToReceiveMagicBytes, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aReadyToReceiveMagicBytes, aReadyToReceiveRetryNumber, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber) {
        super(aDecoratee, aReadyToReceiveMagicBytes, aReadyToReceiveRetryNumber);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aReadyToReceiveMagicBytes, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes, long aReadyToReceiveTimeoutInMs) {
        super(aDecoratee, aReadyToReceiveMagicBytes, aReadyToReceiveTimeoutInMs);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aReadyToReceiveMagicBytes, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, byte[] aReadyToReceiveMagicBytes) {
        super(aDecoratee, aReadyToReceiveMagicBytes);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs) {
        super(aDecoratee, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes, aReadyToReceiveRetryNumber, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes, int aReadyToReceiveRetryNumber) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes, aReadyToReceiveRetryNumber);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes, long aReadyToReceiveTimeoutInMs) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes, aReadyToReceiveTimeoutInMs);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToReceiveMagicBytes) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveMagicBytes);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, int aReadyToReceiveRetryNumber, long aReadyToReceiveTimeoutInMs) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveRetryNumber, aReadyToReceiveTimeoutInMs);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, long aReadyToReceiveTimeoutInMs) {
        super(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToReceiveTimeoutInMs);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, long aReadyToReceiveTimeoutInMs, SegmentPackager aReadyToReceiveSegmentPackager) {
        super(aDecoratee, aReadyToReceiveTimeoutInMs, aReadyToReceiveSegmentPackager);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs) {
        super(aDecoratee, aEnquiryStandbyTimeInMs);
    }

    public ReadyToReceiveSectionDecorator(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        super(aDecoratee, aTransmissionMetrics);
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        ((Section)this._decoratee).fromTransmission(aSequence, aOffset, aLength);
    }

    @Override
    public void receiveFrom(InputStream aInputStream, int aLength, OutputStream aReturnStream) throws IOException, TransmissionException {
        if (aReturnStream == null) {
            ((Section)this._decoratee).receiveFrom(aInputStream, aLength, aReturnStream);
            return;
        }
        RetryCounter theRetries = new RetryCounter(this._readyToReceiveRetryNumber, this._readyToReceiveTimeoutInMs);
        Exception eException = null;
        TimeoutInputStream theTimeoutInputStream = new TimeoutInputStream(aInputStream, this._readyToReceiveTimeoutInMs);
        SkipAvailableInputStream theSkipInputStream = new SkipAvailableInputStream(aInputStream, this._readyToReceiveTimeoutInMs);
        while (theRetries.nextRetry()) {
            theSkipInputStream.skipAvailableWithin(IoTimeout.toTimeoutSleepLoopTimeInMs((long)this._readyToReceiveTimeoutInMs));
            eException = null;
            try {
                this._readyToReceiveSegment.transmitTo(aReturnStream);
                ((Section)this._decoratee).receiveFrom((InputStream)theTimeoutInputStream, aLength, aReturnStream);
                return;
            }
            catch (Exception e) {
                eException = e;
            }
        }
        if (eException != null) {
            throw new FlowControlRetryException(this._readyToReceiveRetryNumber, this._readyToReceiveTimeoutInMs, "Aborting after <" + this._readyToReceiveRetryNumber + "> retries with a timeout for each retry of <" + this._readyToReceiveTimeoutInMs + "> milliseconds: " + eException.getMessage(), eException);
        }
        throw new FlowControlRetryException(this._readyToReceiveRetryNumber, this._readyToReceiveTimeoutInMs, "Aborting after <" + this._readyToReceiveRetryNumber + "> retries with a timeout for each retry of <" + this._readyToReceiveTimeoutInMs + "> milliseconds.");
    }

    public static <DECORATEE extends Section> Builder<DECORATEE> builder() {
        return new Builder();
    }

    public static final class Builder<DECORATEE extends Section>
    implements DecorateeAccessor.DecorateeBuilder<DECORATEE, Builder<DECORATEE>>,
    EnquiryStandbyTimeMillisAccessor.EnquiryStandbyTimeMillisBuilder<Builder<DECORATEE>>,
    ReadyToReceiveTimeoutMillisAccessor.ReadyToReceiveTimeoutMillisBuilder<Builder<DECORATEE>>,
    ReadyToReceiveMagicBytesAccessor.ReadyToReceiveMagicBytesBuilder<Builder<DECORATEE>>,
    ReadyToReceiveSegmentPackagerAccessor.ReadyToReceiveSegmentPackagerBuilder<Builder<DECORATEE>>,
    ReadyToReceiveRetryNumberAccessor.ReadyToReceiveRetryNumberBuilder<Builder<DECORATEE>> {
        private DECORATEE decoratee;
        private long enquiryStandbyTimeInMs = -1L;
        private long readyToReceiveTimeoutInMs = TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS;
        private byte[] readyToReceiveMagicBytes = TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES;
        private SegmentPackager readyToReceiveSegmentPackager;
        private int readyToReceiveRetryNumber = TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER;

        private Builder() {
        }

        public Builder<DECORATEE> withDecoratee(DECORATEE aDecoratee) {
            this.decoratee = aDecoratee;
            return this;
        }

        @Override
        public Builder<DECORATEE> withEnquiryStandbyTimeMillis(long aEnquiryStandbyTimeInMs) {
            this.enquiryStandbyTimeInMs = aEnquiryStandbyTimeInMs;
            return this;
        }

        @Override
        public Builder<DECORATEE> withReadyToReceiveTimeoutMillis(long aReadyToReceiveTimeoutInMs) {
            this.readyToReceiveTimeoutInMs = aReadyToReceiveTimeoutInMs;
            return this;
        }

        @Override
        public Builder<DECORATEE> withReadyToReceiveMagicBytes(byte[] aReadyToReceiveMagicBytes) {
            this.readyToReceiveMagicBytes = aReadyToReceiveMagicBytes;
            return this;
        }

        @Override
        public Builder<DECORATEE> withReadyToReceiveSegmentPackager(SegmentPackager aReadyToReceiveSegmentPackager) {
            this.readyToReceiveSegmentPackager = aReadyToReceiveSegmentPackager;
            return this;
        }

        @Override
        public Builder<DECORATEE> withReadyToReceiveRetryNumber(int aReadyToReceiveRetryNumber) {
            this.readyToReceiveRetryNumber = aReadyToReceiveRetryNumber;
            return this;
        }

        public ReadyToReceiveSectionDecorator<DECORATEE> build() {
            return new ReadyToReceiveSectionDecorator<Builder>(this);
        }
    }
}

