/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialTransceiver;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionException;

public interface Section
extends Transmission {
    default public void fromTransmission(byte[] aChunk, int aLength) throws TransmissionException {
        this.fromTransmission(new ByteArraySequence(aChunk), aLength);
    }

    default public void fromTransmission(Sequence aSequence, int aLength) throws TransmissionException {
        this.fromTransmission(aSequence, 0, aLength);
    }

    default public void fromTransmission(byte[] aChunk, int aOffset, int aLength) throws TransmissionException {
        this.fromTransmission(new ByteArraySequence(aChunk), aOffset, aLength);
    }

    public void fromTransmission(Sequence var1, int var2, int var3) throws TransmissionException;

    default public void receiveFrom(SerialTransceiver aSerialTransceiver, int aLength) throws IOException, TransmissionException {
        this.receiveFrom(aSerialTransceiver.getInputStream(), aLength, aSerialTransceiver.getOutputStream());
    }

    default public void receiveFrom(InputStream aInputStream, int aLength) throws IOException, TransmissionException {
        this.receiveFrom(aInputStream, aLength, null);
    }

    public void receiveFrom(InputStream var1, int var2, OutputStream var3) throws IOException, TransmissionException;

    public static interface SectionMixin
    extends Transmission.TransmissionMixin,
    Section {
        @Override
        default public void receiveFrom(InputStream aInputStream, int aLength, OutputStream aReturnStream) throws IOException, TransmissionException {
            byte[] theChunk = Transmission.fromInputStream(aInputStream, aLength);
            this.fromTransmission(theChunk, theChunk.length);
            if (theChunk.length != this.getLength()) {
                throw new TransmissionException("The length <" + aLength + "> to process from the input stream is not equal to the actually resulting length <" + this.getLength() + ">.");
            }
        }
    }
}

