/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import org.refcodes.serial.AbstractTransmissionComposite;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionComposite;
import org.refcodes.serial.TransmissionException;

public class SegmentComposite<CHILD extends Segment>
extends AbstractTransmissionComposite<CHILD>
implements Segment,
Segment.SegmentMixin,
TransmissionComposite<CHILD> {
    private static final long serialVersionUID = 1L;

    public SegmentComposite(Collection<CHILD> aSegments) {
        if (aSegments != null && aSegments.size() != 0) {
            this._children = new Segment[aSegments.size()];
            this._children = aSegments.toArray((Segment[])this._children);
        } else {
            this._children = new Segment[0];
        }
    }

    @SafeVarargs
    public SegmentComposite(CHILD ... aSegments) {
        super(aSegments);
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        int eOffset = aOffset;
        for (int i = 0; i < ((Segment[])this.getChildren()).length; ++i) {
            eOffset = ((Segment[])this.getChildren())[i].fromTransmission(aSequence, eOffset);
        }
        return eOffset;
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException, TransmissionException {
        for (int i = 0; i < ((Segment[])this.getChildren()).length; ++i) {
            ((Segment[])this._children)[i].receiveFrom(aInputStream, aReturnStream);
        }
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema[] theSchemas = null;
        if (this._children != null && ((Segment[])this._children).length != 0) {
            theSchemas = new SerialSchema[((Segment[])this._children).length];
            for (int i = 0; i < theSchemas.length; ++i) {
                theSchemas[i] = ((Segment[])this._children)[i].toSchema();
            }
        }
        return new SerialSchema(this.getClass(), "A body containing a composite segment as payload.", this.toSequence(), this.getLength(), theSchemas);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this._children);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentComposite other = (SegmentComposite)obj;
        return Arrays.equals(this._children, other._children);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [children=" + Arrays.toString(this._children) + "]";
    }
}

