/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceAccessor;

public class SequenceOutputStream
extends OutputStream
implements SequenceAccessor {
    private Sequence _sequence;
    boolean _isClosed = false;

    public SequenceOutputStream() {
        this._sequence = new ByteArraySequence();
    }

    public SequenceOutputStream(Sequence aSequence) {
        this._sequence = aSequence;
    }

    @Override
    public void close() throws IOException {
        this._isClosed = true;
        super.close();
    }

    @Override
    public void write(byte[] aBytes, int aOffset, int aLength) throws IOException {
        if (this._isClosed) {
            throw new IOException("The stream has already been closed!");
        }
        this._sequence.append(aBytes, aOffset, aLength);
    }

    @Override
    public void write(int aByte) throws IOException {
        if (this._isClosed) {
            throw new IOException("The stream has already been closed!");
        }
        this._sequence.append((byte)aByte);
    }

    @Override
    public Sequence getSequence() {
        return this._sequence;
    }
}

