/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.PayloadSection;
import org.refcodes.serial.PayloadTransmission;
import org.refcodes.serial.Section;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapBuilderImpl;
import org.refcodes.textual.CaseStyleBuilder;

public class SequenceSection
implements PayloadSection<Sequence>,
Section.SectionMixin {
    private static final long serialVersionUID = 1L;
    protected Sequence _sequence;
    protected String _alias;

    public SequenceSection() {
        this(CaseStyleBuilder.asCamelCase((String)SequenceSection.class.getSimpleName()), new ByteArraySequence());
    }

    public SequenceSection(String aAlias) {
        this(aAlias, new ByteArraySequence());
    }

    public SequenceSection(int aSequenceSize) {
        this(CaseStyleBuilder.asCamelCase((String)SequenceSection.class.getSimpleName()), aSequenceSize);
    }

    public SequenceSection(String aAlias, int aSequenceSize) {
        this(aAlias, new ByteArraySequence(aSequenceSize));
    }

    public SequenceSection(Sequence aSequence) {
        this(CaseStyleBuilder.asCamelCase((String)SequenceSection.class.getSimpleName()), aSequence);
    }

    public SequenceSection(String aAlias, Sequence aSequence) {
        this._alias = aAlias;
        this._sequence = aSequence;
    }

    @Override
    public int getLength() {
        return this._sequence.getLength();
    }

    @Override
    public Sequence toSequence() {
        return this._sequence;
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        this._sequence.replace(aSequence.toSequence(aOffset, aLength));
    }

    @Override
    public SerialSchema toSchema() {
        return new SerialSchema(this.getClass(), "A section consisting of a sequence.", this.getAlias(), this.toSequence(), this.getLength());
    }

    public String getAlias() {
        return this._alias;
    }

    public PayloadTransmission<Sequence> withPayload(Sequence aValue) {
        this.setPayload(aValue);
        return this;
    }

    public Sequence getPayload() {
        return this._sequence;
    }

    public void setPayload(Sequence aValue) {
        this._sequence = aValue;
    }

    @Override
    public SimpleTypeMap toSimpleTypeMap() {
        return new SimpleTypeMapBuilderImpl().withPut(this._alias, this._sequence != null ? this._sequence.toBytes() : null);
    }
}

