/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import org.refcodes.component.LinkComponent;
import org.refcodes.io.BytesReceiver;
import org.refcodes.io.Skippable;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentReceiver;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.TransmissionException;

public interface SerialReceiver
extends BytesReceiver,
SegmentReceiver,
LinkComponent.LinkAutomaton,
Skippable {
    public int available() throws IOException;

    default public byte receiveByte() throws IOException {
        return this.receiveBytes(1)[0];
    }

    default public byte[] receiveBytes(int aMaxLength) throws IOException {
        byte[] theChunk = new byte[aMaxLength];
        this.receiveBytes(theChunk, 0, aMaxLength);
        return theChunk;
    }

    default public Sequence receiveSequenceWithin(long aTimeoutMillis, int aLength) throws IOException {
        return new ByteArraySequence(this.receiveBytesWithin(aTimeoutMillis, aLength));
    }

    default public Sequence receiveSequence(int aLength) throws IOException {
        return new ByteArraySequence(this.receiveBytes(aLength));
    }

    @Override
    default public <SEGMENT extends Segment> void receiveSegmentWithin(long aTimeoutMillis, SEGMENT aSegment) throws TransmissionException, IOException {
        aSegment.receiveFrom((InputStream)this.getInputStream(aTimeoutMillis), null);
    }

    @Override
    default public <SEGMENT extends Segment> void receiveSegment(SEGMENT aSegment) throws TransmissionException, IOException {
        aSegment.receiveFrom(this.getInputStream(), null);
    }

    public void open() throws IOException;

    public void close() throws IOException;
}

