/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.util.Arrays;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractPayloadSection;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.PayloadSection;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.TransmissionSequenceException;
import org.refcodes.textual.CaseStyleBuilder;

public class ShortArraySection
extends AbstractPayloadSection<short[]>
implements PayloadSection<short[]> {
    private static final long serialVersionUID = 1L;
    public static final String ENDIANESS = "ENDIANESS";
    private Endianess _endianess;

    public ShortArraySection(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEndianess());
    }

    public ShortArraySection(TransmissionMetrics aTransmissionMetrics, short ... aValue) {
        this(aTransmissionMetrics.getEndianess(), aValue);
    }

    public ShortArraySection(TransmissionMetrics aTransmissionMetrics, Short ... aValue) {
        this(aTransmissionMetrics.getEndianess(), aValue);
    }

    public ShortArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getEndianess());
    }

    public ShortArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics, short ... aValue) {
        this(aAlias, aTransmissionMetrics.getEndianess(), aValue);
    }

    public ShortArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics, Short ... aValue) {
        this(aAlias, aTransmissionMetrics.getEndianess(), aValue);
    }

    public ShortArraySection() {
        this(CaseStyleBuilder.asCamelCase((String)ShortArraySection.class.getSimpleName()), TransmissionMetrics.DEFAULT_ENDIANESS, new short[0]);
    }

    public ShortArraySection(Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)ShortArraySection.class.getSimpleName()), aEndianess, new short[0]);
    }

    public ShortArraySection(short ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)ShortArraySection.class.getSimpleName()), TransmissionMetrics.DEFAULT_ENDIANESS, aValue);
    }

    public ShortArraySection(Short ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)ShortArraySection.class.getSimpleName()), TransmissionMetrics.DEFAULT_ENDIANESS, aValue);
    }

    public ShortArraySection(Endianess aEndianess, short ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)ShortArraySection.class.getSimpleName()), aEndianess, aValue);
    }

    public ShortArraySection(Endianess aEndianess, Short ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)ShortArraySection.class.getSimpleName()), aEndianess, ShortArraySection.toPrimitiveArray(aValue));
    }

    public ShortArraySection(String aAlias) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, new short[0]);
    }

    public ShortArraySection(String aAlias, Endianess aEndianess) {
        this(aAlias, aEndianess, new short[0]);
    }

    public ShortArraySection(String aAlias, short ... aValue) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, aValue);
    }

    public ShortArraySection(String aAlias, Short ... aValue) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, aValue);
    }

    public ShortArraySection(String aAlias, Endianess aEndianess, short ... aValue) {
        super(aAlias, aValue);
        this._endianess = aEndianess;
    }

    public ShortArraySection(String aAlias, Endianess aEndianess, Short ... aValue) {
        super(aAlias, ShortArraySection.toPrimitiveArray(aValue));
        this._endianess = aEndianess;
    }

    @Override
    public Sequence toSequence() {
        byte[] theBytes = new byte[((short[])this.getPayload()).length * 2];
        for (int i = 0; i < ((short[])this.getPayload()).length; i = (int)((short)(i + 1))) {
            byte[] eRecord = this._endianess.toBytes(((short[])this.getPayload())[i], 2);
            for (int j = 0; j < eRecord.length; j = (int)((short)(j + 1))) {
                theBytes[i * 2 + j] = eRecord[j];
            }
        }
        return new ByteArraySequence(theBytes);
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        if (aLength % 2 != 0) {
            throw new TransmissionSequenceException(aSequence, "The length dedicated <" + aLength + "> does not match a multiple short length <2> for retrieving an short array from the given sequence at the offset <" + aOffset + ">!");
        }
        short[] theValues = new short[aLength / 2];
        for (int i = 0; i < theValues.length; i = (int)((short)(i + 1))) {
            byte[] eRecord = aSequence.toBytes(aOffset + i * 2, 2);
            theValues[i] = this._endianess.toShort(eRecord);
        }
        this.setPayload(theValues);
    }

    @Override
    public int getLength() {
        return this.getPayload() != null ? ((short[])this.getPayload()).length * 2 : 0;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getClass(), "A body containing an short payload.", this.getAlias(), this.toSequence(), this.getLength());
        theSchema.put(ENDIANESS, this._endianess);
        return theSchema;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", value=" + Arrays.toString((short[])this.getPayload()) + "]";
    }

    public ShortArraySection withPayload(short[] aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public void setPayload(Short[] aPayload) {
        this.setPayload(ShortArraySection.toPrimitiveArray(aPayload));
    }

    public ShortArraySection withPayload(Short[] aPayload) {
        this.setPayload(ShortArraySection.toPrimitiveArray(aPayload));
        return this;
    }

    private static short[] toPrimitiveArray(Short[] aPayload) {
        short[] theResult = new short[aPayload.length];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = aPayload[i];
        }
        return theResult;
    }
}

