/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractPayloadSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.textual.CaseStyleBuilder;

public class ShortSegment
extends AbstractPayloadSegment<Short>
implements Segment {
    private static final long serialVersionUID = 1L;
    public static final String ENDIANESS = "ENDIANESS";
    public static final int BYTES = 2;
    private Endianess _endianess;

    public ShortSegment(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEndianess());
    }

    public ShortSegment(Short aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aValue, aTransmissionMetrics.getEndianess());
    }

    public ShortSegment(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getEndianess());
    }

    public ShortSegment(String aAlias, Short aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aValue, aTransmissionMetrics.getEndianess());
    }

    public ShortSegment() {
        this(CaseStyleBuilder.asCamelCase((String)ShortSegment.class.getSimpleName()));
    }

    public ShortSegment(Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)ShortSegment.class.getSimpleName()), aEndianess);
    }

    public ShortSegment(Short aValue) {
        this(CaseStyleBuilder.asCamelCase((String)ShortSegment.class.getSimpleName()), aValue);
    }

    public ShortSegment(Short aValue, Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)ShortSegment.class.getSimpleName()), aValue, aEndianess);
    }

    public ShortSegment(String aAlias) {
        this(aAlias, (Short)0, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public ShortSegment(String aAlias, Endianess aEndianess) {
        this(aAlias, (Short)0, aEndianess);
    }

    public ShortSegment(String aAlias, Short aValue) {
        this(aAlias, aValue, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public ShortSegment(String aAlias, Short aValue, Endianess aEndianess) {
        super(aAlias, aValue);
        this._endianess = aEndianess;
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence(this._endianess.toBytes(((Short)this.getPayload()).shortValue(), 2));
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        byte[] theRecord = aSequence.toBytes(aOffset, 2);
        this.setPayload(this._endianess.toShort(theRecord));
        return aOffset + 2;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getClass(), "A body containing an short payload.", this.getAlias(), this.toSequence(), "" + this.getPayload(), this.getLength());
        theSchema.put(ENDIANESS, this._endianess);
        return theSchema;
    }

    public ShortSegment withPayload(Short aValue) {
        this.setPayload(aValue);
        return this;
    }
}

