/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.io.SkipAvailableInputStream;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AcknowledgeMagicBytesAccessor;
import org.refcodes.serial.AcknowledgeRetryNumberAccessor;
import org.refcodes.serial.AcknowledgeSegmentPackagerAccessor;
import org.refcodes.serial.AcknowledgeTimeoutMillisAccessor;
import org.refcodes.serial.CrcSegmentPackager;
import org.refcodes.serial.FlowControlRetryException;
import org.refcodes.serial.MagicBytesSegment;
import org.refcodes.serial.NumberSegment;
import org.refcodes.serial.OutputReturnStreamAccessor;
import org.refcodes.serial.PacketInputStream;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentComposite;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.TransmissionMetrics;

public class StopAndWaitPacketInputStream
extends PacketInputStream
implements AcknowledgeRetryNumberAccessor,
AcknowledgeTimeoutMillisAccessor,
AcknowledgeMagicBytesAccessor,
AcknowledgeSegmentPackagerAccessor {
    private static final boolean IS_DEBUG = false;
    byte[] _acknowledgeMagicBytes;
    int _acknowledgeRetryNumber;
    Segment _acknowledgeSegment;
    SegmentPackager _acknowledgeSegmentPackager;
    NumberSegment _acknowledgeSequenceNumberSegment;
    long _acknowledgeTimeoutInMs;
    OutputStream _returnStream;

    public static Builder builder() {
        return new Builder();
    }

    private StopAndWaitPacketInputStream(Builder aBuilder) {
        this(aBuilder.inputStream, aBuilder.blockSize, aBuilder.truncateLengthWidth, aBuilder.packetMagicBytes, aBuilder.sequenceNumberInitValue, aBuilder.sequenceNumberWidth, aBuilder.sequenceNumberConcatenateMode, aBuilder.toPacketSegmentPackager(), aBuilder.returnStream, aBuilder.acknowledgeMagicBytes, aBuilder.acknowledgeRetryNumber, aBuilder.acknowledgeTimeoutInMs, aBuilder.toAckSegmentPackager(), aBuilder.endianess);
    }

    public StopAndWaitPacketInputStream(InputStream aInputStream, OutputStream aReturnStream, TransmissionMetrics aTransmissionMetrics) {
        this(aInputStream, aTransmissionMetrics.getBlockSize(), aTransmissionMetrics.getPacketLengthWidth(), aTransmissionMetrics.getPacketMagicBytes(), aTransmissionMetrics.getSequenceNumberInitValue(), aTransmissionMetrics.getSequenceNumberWidth(), aTransmissionMetrics.getSequenceNumberConcatenateMode(), aTransmissionMetrics.toPacketSegmentPackager(), aReturnStream, aTransmissionMetrics.getAcknowledgeMagicBytes(), aTransmissionMetrics.getAcknowledgeRetryNumber(), aTransmissionMetrics.getAcknowledgeTimeoutMillis(), aTransmissionMetrics.toAckSegmentPackager(), aTransmissionMetrics.getEndianess());
    }

    public StopAndWaitPacketInputStream(InputStream aInputStream, int aBlockSize, int aPacketLengthWidth, byte[] aPacketMagicBytes, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, SegmentPackager aPacketSegmentPackager, OutputStream aReturnStream, byte[] aAcknowledgeMagicBytes, int aAcknowledgeRetryNumber, long aAcknowledgeTimeoutInMs, SegmentPackager aAckSegmentPackager, Endianess aEndianess) {
        super(aInputStream, aBlockSize, aPacketLengthWidth, aPacketMagicBytes, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aPacketSegmentPackager, aEndianess);
        this._returnStream = aReturnStream;
        this._acknowledgeMagicBytes = aAcknowledgeMagicBytes;
        this._acknowledgeRetryNumber = aAcknowledgeRetryNumber;
        this._acknowledgeTimeoutInMs = aAcknowledgeTimeoutInMs;
        this._acknowledgeSegmentPackager = aAckSegmentPackager != null ? aAckSegmentPackager : new SegmentPackager.DummySegmentPackager();
        Segment[] segmentArray = new Segment.SegmentMixin[2];
        segmentArray[0] = new MagicBytesSegment(this._acknowledgeMagicBytes);
        this._acknowledgeSequenceNumberSegment = new NumberSegment(aSequenceNumberWidth, aEndianess);
        segmentArray[1] = this._acknowledgeSequenceNumberSegment;
        this._acknowledgeSegment = this._acknowledgeSegmentPackager.toPackaged(new SegmentComposite(segmentArray));
    }

    @Override
    public byte[] getAcknowledgeMagicBytes() {
        return this._acknowledgeMagicBytes;
    }

    @Override
    public int getAcknowledgeRetryNumber() {
        return this._acknowledgeRetryNumber;
    }

    @Override
    public SegmentPackager getAcknowledgeSegmentPackager() {
        return this._acknowledgeSegmentPackager;
    }

    @Override
    public long getAcknowledgeTimeoutMillis() {
        return this._acknowledgeTimeoutInMs;
    }

    @Override
    protected void doReceivePacket() throws IOException {
        if (this._returnStream == null) {
            super.doReceivePacket();
            return;
        }
        RetryCounter theRetries = new RetryCounter(this._acknowledgeRetryNumber, this._acknowledgeTimeoutInMs);
        Exception eException = null;
        SkipAvailableInputStream theSkipInputStream = new SkipAvailableInputStream(this._inputStream, this._acknowledgeTimeoutInMs);
        while (theRetries.nextRetry()) {
            eException = null;
            try {
                this._packetSegment.receiveFrom(this._inputStream);
                long eSequenceNumber = ((Long)this._sequenceNumberSegment.getPayload()).intValue();
                if (this._sequenceNumberInitValue == -1 && this._sequenceNumber == 0 || eSequenceNumber == (long)this._sequenceNumber) {
                    this._acknowledgeSequenceNumberSegment.setPayload(eSequenceNumber);
                    this._acknowledgeSegment.transmitTo(this._returnStream);
                    ++this._sequenceNumber;
                    this._blockOffset = 0;
                    return;
                }
            }
            catch (Exception e) {
                eException = e;
            }
            if (!theRetries.hasNextRetry()) continue;
            try {
                theSkipInputStream.skipAvailableTillSilenceFor(this._acknowledgeTimeoutInMs * 8L / 10L);
            }
            catch (IOException iOException) {}
        }
        if (eException != null) {
            throw new FlowControlRetryException(this._acknowledgeRetryNumber, this._acknowledgeTimeoutInMs, "Aborting after <" + this._acknowledgeRetryNumber + "> retries with a timeout for each retry of <" + this._acknowledgeTimeoutInMs + "> milliseconds: " + eException.getMessage(), eException);
        }
        throw new FlowControlRetryException(this._acknowledgeRetryNumber, this._acknowledgeTimeoutInMs, "Aborting after <" + this._acknowledgeRetryNumber + "> retries with a timeout for each retry of <" + this._acknowledgeTimeoutInMs + "> milliseconds.");
    }

    public static class Builder
    extends PacketInputStream.Builder
    implements AcknowledgeMagicBytesAccessor.AcknowledgeMagicBytesBuilder<Builder>,
    AcknowledgeTimeoutMillisAccessor.AcknowledgeTimeoutMillisBuilder<Builder>,
    AcknowledgeRetryNumberAccessor.AcknowledgeRetryNumberBuilder<Builder>,
    OutputReturnStreamAccessor.OutputReturnStreamBuilder<Builder>,
    AcknowledgeSegmentPackagerAccessor.AcknowledgeSegmentPackagerBuilder<Builder> {
        byte[] acknowledgeMagicBytes = TransmissionMetrics.DEFAULT_ACKNOWLEDGE_MAGIC_BYTES;
        int acknowledgeRetryNumber = TransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER;
        SegmentPackager acknowledgeSegmentPackager = null;
        long acknowledgeTimeoutInMs = TransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS;
        OutputStream returnStream = null;

        protected Builder() {
        }

        @Override
        public StopAndWaitPacketInputStream build() {
            return new StopAndWaitPacketInputStream(this);
        }

        @Override
        public Builder withAcknowledgeMagicBytes(byte[] aAcknowledgeMagicBytes) {
            this.acknowledgeMagicBytes = aAcknowledgeMagicBytes;
            return this;
        }

        @Override
        public Builder withAcknowledgeRetryNumber(int aAcknowledgeRetryNumber) {
            this.acknowledgeRetryNumber = aAcknowledgeRetryNumber;
            return this;
        }

        @Override
        public Builder withAcknowledgeSegmentPackager(SegmentPackager aAcknowledgeSegmentPackager) {
            this.acknowledgeSegmentPackager = aAcknowledgeSegmentPackager;
            return this;
        }

        @Override
        public Builder withAcknowledgeTimeoutMillis(long aAcknowledgeTimeoutInMs) {
            this.acknowledgeTimeoutInMs = aAcknowledgeTimeoutInMs;
            return this;
        }

        @Override
        public Builder withCrcAlgorithm(CrcAlgorithm aCrcAlgorithm) {
            this.crcAlgorithm = aCrcAlgorithm;
            return this;
        }

        @Override
        public Builder withCrcChecksumConcatenateMode(ConcatenateMode aCrcChecksumConcatenateMode) {
            this.crcChecksumConcatenateMode = aCrcChecksumConcatenateMode;
            return this;
        }

        @Override
        public Builder withChecksumValidationMode(ChecksumValidationMode aChecksumValidationMode) {
            this.crcChecksumValidationMode = aChecksumValidationMode;
            return this;
        }

        @Override
        public Builder withPacketSegmentPackager(SegmentPackager aPacketSegmentPackager) {
            this.packetSegmentPackager = aPacketSegmentPackager;
            return this;
        }

        @Override
        public Builder withReturnStream(OutputStream aReturnStream) {
            this.returnStream = aReturnStream;
            return this;
        }

        SegmentPackager toAckSegmentPackager() {
            if (this.acknowledgeSegmentPackager != null) {
                return this.acknowledgeSegmentPackager;
            }
            if (this.crcAlgorithm != null || this.crcChecksumValidationMode != null) {
                CrcAlgorithm theCrcAlgorithm = this.crcAlgorithm != null ? this.crcAlgorithm : TransmissionMetrics.DEFAULT_CRC_ALGORITHM;
                ChecksumValidationMode theCrcChecksumValidationMode = this.crcChecksumValidationMode != null ? this.crcChecksumValidationMode : TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE;
                ConcatenateMode theCrcChecksumConcatenateMode = this.crcChecksumConcatenateMode != null ? this.crcChecksumConcatenateMode : TransmissionMetrics.DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE;
                Endianess theEndianess = this.endianess != null ? this.endianess : TransmissionMetrics.DEFAULT_ENDIANESS;
                return new CrcSegmentPackager(theCrcAlgorithm, theCrcChecksumConcatenateMode, theCrcChecksumValidationMode, theEndianess);
            }
            return new SegmentPackager.DummySegmentPackager();
        }

        @Override
        SegmentPackager toPacketSegmentPackager() {
            if (this.packetSegmentPackager != null) {
                return this.packetSegmentPackager;
            }
            if (this.crcAlgorithm != null || this.crcChecksumValidationMode != null) {
                CrcAlgorithm theCrcAlgorithm = this.crcAlgorithm != null ? this.crcAlgorithm : TransmissionMetrics.DEFAULT_CRC_ALGORITHM;
                ChecksumValidationMode theCrcChecksumValidationMode = this.crcChecksumValidationMode != null ? this.crcChecksumValidationMode : TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE;
                ConcatenateMode theCrcChecksumConcatenateMode = this.crcChecksumConcatenateMode != null ? this.crcChecksumConcatenateMode : TransmissionMetrics.DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE;
                Endianess theEndianess = this.endianess != null ? this.endianess : TransmissionMetrics.DEFAULT_ENDIANESS;
                return new CrcSegmentPackager(theCrcAlgorithm, theCrcChecksumConcatenateMode, theCrcChecksumValidationMode, theEndianess);
            }
            return new SegmentPackager.DummySegmentPackager();
        }
    }
}

