/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.mixin.BlockSizeAccessor;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.mixin.ConcatenateModeAccessor;
import org.refcodes.mixin.DecorateeAccessor;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.ChecksumValidationModeAccessor;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcAlgorithmAccessor;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.EndianessAccessor;
import org.refcodes.serial.AbstractStopAndWaitPacketStreamTransmissionDecorator;
import org.refcodes.serial.AcknowledgeMagicBytesAccessor;
import org.refcodes.serial.AcknowledgeRetryNumberAccessor;
import org.refcodes.serial.AcknowledgeSegmentPackagerAccessor;
import org.refcodes.serial.AcknowledgeTimeoutMillisAccessor;
import org.refcodes.serial.CrcSegmentPackager;
import org.refcodes.serial.DecoratorSection;
import org.refcodes.serial.PacketLengthWidthAccessor;
import org.refcodes.serial.PacketMagicBytesAccessor;
import org.refcodes.serial.PacketSegmentPackagerAccessor;
import org.refcodes.serial.Section;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceNumberInitValueAccessor;
import org.refcodes.serial.SequenceNumberWidthAccessor;
import org.refcodes.serial.StopAndWaitPacketInputStream;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;

public class StopAndWaitPacketStreamSectionDecorator<DECORATEE extends Section>
extends AbstractStopAndWaitPacketStreamTransmissionDecorator<DECORATEE>
implements Section,
DecoratorSection<DECORATEE> {
    private static final long serialVersionUID = 1L;

    private StopAndWaitPacketStreamSectionDecorator(Builder<DECORATEE> aBuilder) {
        this(aBuilder.decoratee, aBuilder.blockSize, aBuilder.truncateLengthWidth, aBuilder.packetMagicBytes, aBuilder.lastPacketMagicBytes, aBuilder.sequenceNumberInitValue, aBuilder.sequenceNumberWidth, aBuilder.sequenceNumberConcatenateMode, aBuilder.toPacketSegmentPackager(), aBuilder.acknowledgeMagicBytes, aBuilder.ackRetryNumber, aBuilder.ackTimeoutInMs, aBuilder.toAckSegmentPackager(), aBuilder.endianess);
    }

    public StopAndWaitPacketStreamSectionDecorator(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        super(aDecoratee, aTransmissionMetrics);
    }

    public StopAndWaitPacketStreamSectionDecorator(DECORATEE aDecoratee, int aBlockSize, int aPacketLengthWidth, byte[] aPacketMagicBytes, byte[] aLastPacketMagicBytes, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, SegmentPackager aPacketSegmentPackager, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, SegmentPackager aAckSegmentPackager, Endianess aEndianess) {
        super(aDecoratee, aBlockSize, aPacketLengthWidth, aPacketMagicBytes, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aPacketSegmentPackager, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aAckSegmentPackager, aEndianess);
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        ((Section)this._decoratee).fromTransmission(aSequence, aOffset, aLength);
    }

    @Override
    public void receiveFrom(InputStream aInputStream, int aLength, OutputStream aReturnStream) throws IOException, TransmissionException {
        StopAndWaitPacketInputStream thePacketInputStream = new StopAndWaitPacketInputStream(aInputStream, this._blockSize, this._packetLengthWidth, this._packetMagicBytes, this._sequenceNumberInitValue, this._sequenceNumberWidth, this._sequenceNumberConcatenateMode, this._packetSegmentPackager, aReturnStream, this._acknowledgeMagicBytes, this._acknowledgeRetryNumber, this._acknowledgeTimeoutInMs, this._acknowledgeSegmentPackager, this._endianess);
        this._packetSize = thePacketInputStream.getPacketSize();
        ((Section)this._decoratee).receiveFrom(thePacketInputStream, aLength, aReturnStream);
    }

    public static <DECORATEE extends Section> Builder<DECORATEE> builder() {
        return new Builder();
    }

    public static final class Builder<DECORATEE extends Section>
    implements AcknowledgeRetryNumberAccessor.AcknowledgeRetryNumberBuilder<Builder<DECORATEE>>,
    AcknowledgeTimeoutMillisAccessor.AcknowledgeTimeoutMillisBuilder<Builder<DECORATEE>>,
    DecorateeAccessor.DecorateeBuilder<DECORATEE, Builder<DECORATEE>>,
    AcknowledgeMagicBytesAccessor.AcknowledgeMagicBytesBuilder<Builder<DECORATEE>>,
    SequenceNumberWidthAccessor.SequenceNumberWidthBuilder<Builder<DECORATEE>>,
    SequenceNumberInitValueAccessor.SequenceNumberInitValueBuilder<Builder<DECORATEE>>,
    ConcatenateModeAccessor.ConcatenateModeBuilder<Builder<DECORATEE>>,
    ChecksumValidationModeAccessor.ChecksumValidationModeBuilder<Builder<DECORATEE>>,
    CrcAlgorithmAccessor.CrcAlgorithmBuilder<Builder<DECORATEE>>,
    BlockSizeAccessor.BlockSizeBuilder<Builder<DECORATEE>>,
    EndianessAccessor.EndianessBuilder<Builder<DECORATEE>>,
    AcknowledgeSegmentPackagerAccessor.AcknowledgeSegmentPackagerBuilder<Builder<DECORATEE>>,
    PacketSegmentPackagerAccessor.PacketSegmentPackagerBuilder<Builder<DECORATEE>>,
    PacketLengthWidthAccessor.PacketLengthWidthBuilder<Builder<DECORATEE>>,
    PacketMagicBytesAccessor.PacketMagicBytesBuilder<Builder<DECORATEE>> {
        private DECORATEE decoratee = null;
        private int ackRetryNumber = TransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER;
        private long ackTimeoutInMs = TransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS;
        private byte[] acknowledgeMagicBytes = TransmissionMetrics.DEFAULT_ACKNOWLEDGE_MAGIC_BYTES;
        private int sequenceNumberWidth = 4;
        private int sequenceNumberInitValue = -1;
        private ConcatenateMode sequenceNumberConcatenateMode = TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE;
        private Endianess endianess = TransmissionMetrics.DEFAULT_ENDIANESS;
        private int blockSize = 1024;
        private CrcAlgorithm crcAlgorithm = null;
        private ConcatenateMode crcChecksumConcatenateMode = null;
        private ChecksumValidationMode crcChecksumValidationMode = null;
        private SegmentPackager packetSegmentPackager = null;
        private SegmentPackager ackSegmentPackager = null;
        byte[] lastPacketMagicBytes = TransmissionMetrics.DEFAULT_LAST_PACKET_MAGIC_BYTES;
        byte[] packetMagicBytes = TransmissionMetrics.DEFAULT_PACKET_MAGIC_BYTES;
        int truncateLengthWidth = 4;

        private Builder() {
        }

        @Override
        public Builder<DECORATEE> withAcknowledgeRetryNumber(int aAcknowledgeRetryNumber) {
            this.ackRetryNumber = aAcknowledgeRetryNumber;
            return this;
        }

        @Override
        public Builder<DECORATEE> withAcknowledgeTimeoutMillis(long aAckTimeoutInMs) {
            this.ackTimeoutInMs = aAckTimeoutInMs;
            return this;
        }

        public Builder<DECORATEE> withDecoratee(DECORATEE aDecoratee) {
            this.decoratee = aDecoratee;
            return this;
        }

        @Override
        public Builder<DECORATEE> withAcknowledgeMagicBytes(byte[] aAcknowledgeMagicBytes) {
            this.acknowledgeMagicBytes = aAcknowledgeMagicBytes;
            return this;
        }

        @Override
        public Builder<DECORATEE> withSequenceNumberWidth(int aSequenceNumberWidth) {
            this.sequenceNumberWidth = aSequenceNumberWidth;
            return this;
        }

        @Override
        public Builder<DECORATEE> withSequenceNumberInitValue(int aSequenceNumberInitValue) {
            this.sequenceNumberInitValue = aSequenceNumberInitValue;
            return this;
        }

        public Builder<DECORATEE> withConcatenateMode(ConcatenateMode aConcatenateMode) {
            this.sequenceNumberConcatenateMode = aConcatenateMode;
            return this;
        }

        public Builder<DECORATEE> withCrcAlgorithm(CrcAlgorithm aCrcAlgorithm) {
            this.crcAlgorithm = aCrcAlgorithm;
            return this;
        }

        public Builder<DECORATEE> withChecksumValidationMode(ChecksumValidationMode aChecksumValidationMode) {
            this.crcChecksumValidationMode = aChecksumValidationMode;
            return this;
        }

        public Builder<DECORATEE> withEndianess(Endianess aEndianess) {
            this.endianess = aEndianess;
            return this;
        }

        public Builder<DECORATEE> withBlockSize(int aBlockSize) {
            this.blockSize = aBlockSize;
            return this;
        }

        @Override
        public Builder<DECORATEE> withAcknowledgeSegmentPackager(SegmentPackager aAcknowledgeSegmentPackager) {
            this.ackSegmentPackager = aAcknowledgeSegmentPackager;
            return this;
        }

        @Override
        public Builder<DECORATEE> withPacketMagicBytes(byte[] aPacketMagicBytes) {
            this.packetMagicBytes = aPacketMagicBytes;
            return this;
        }

        @Override
        public Builder<DECORATEE> withPacketLengthWidth(int aPacketLengthWidth) {
            this.truncateLengthWidth = aPacketLengthWidth;
            return this;
        }

        SegmentPackager toAckSegmentPackager() {
            if (this.ackSegmentPackager != null) {
                return this.ackSegmentPackager;
            }
            if (this.crcAlgorithm != null || this.crcChecksumValidationMode != null) {
                CrcAlgorithm theCrcAlgorithm = this.crcAlgorithm != null ? this.crcAlgorithm : TransmissionMetrics.DEFAULT_CRC_ALGORITHM;
                ChecksumValidationMode theCrcChecksumValidationMode = this.crcChecksumValidationMode != null ? this.crcChecksumValidationMode : TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE;
                ConcatenateMode theCrcChecksumConcatenateMode = this.crcChecksumConcatenateMode != null ? this.crcChecksumConcatenateMode : TransmissionMetrics.DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE;
                Endianess theEndianess = this.endianess != null ? this.endianess : TransmissionMetrics.DEFAULT_ENDIANESS;
                return new CrcSegmentPackager(theCrcAlgorithm, theCrcChecksumConcatenateMode, theCrcChecksumValidationMode, theEndianess);
            }
            return new SegmentPackager.DummySegmentPackager();
        }

        @Override
        public Builder<DECORATEE> withPacketSegmentPackager(SegmentPackager aPacketSegmentPackager) {
            this.packetSegmentPackager = aPacketSegmentPackager;
            return this;
        }

        SegmentPackager toPacketSegmentPackager() {
            if (this.packetSegmentPackager != null) {
                return this.packetSegmentPackager;
            }
            if (this.crcAlgorithm != null || this.crcChecksumValidationMode != null) {
                CrcAlgorithm theCrcAlgorithm = this.crcAlgorithm != null ? this.crcAlgorithm : TransmissionMetrics.DEFAULT_CRC_ALGORITHM;
                ChecksumValidationMode theCrcChecksumValidationMode = this.crcChecksumValidationMode != null ? this.crcChecksumValidationMode : TransmissionMetrics.DEFAULT_CHECKSUM_VALIDATION_MODE;
                ConcatenateMode theCrcChecksumConcatenateMode = this.crcChecksumConcatenateMode != null ? this.crcChecksumConcatenateMode : TransmissionMetrics.DEFAULT_CRC_CHECKSUM_CONCATENATE_MODE;
                Endianess theEndianess = this.endianess != null ? this.endianess : TransmissionMetrics.DEFAULT_ENDIANESS;
                return new CrcSegmentPackager(theCrcAlgorithm, theCrcChecksumConcatenateMode, theCrcChecksumValidationMode, theEndianess);
            }
            return new SegmentPackager.DummySegmentPackager();
        }

        public StopAndWaitPacketStreamSectionDecorator<DECORATEE> build() {
            return new StopAndWaitPacketStreamSectionDecorator(this);
        }
    }
}

