// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.serial;

/**
 * Provides an accessor for a ENQ ("enquiry") timeout in milliseconds property.
 */
public interface EnquiryStandbyTimeMillisAccessor {

	/**
	 * The ENQ ("enquiry") timeout attribute in milliseconds.
	 * 
	 * @return An integer with the ENQ ("enquiry") timeout in milliseconds.
	 */
	long getEnquiryStandbyTimeMillis();

	/**
	 * Provides a mutator for a ENQ ("enquiry") timeout in milliseconds
	 * property.
	 */
	public interface EnquiryStandbyTimeMillisMutator {

		/**
		 * The ENQ ("enquiry") timeout attribute in milliseconds.
		 * 
		 * @param aEnquiryStandbyTimeMillis An integer with the ENQ ("enquiry")
		 *        timeout in milliseconds.
		 */
		void setEnquiryStandbyTimeMillis( long aEnquiryStandbyTimeMillis );
	}

	/**
	 * Provides a builder method for a the ENQ ("enquiry") timeout property
	 * returning the builder for applying multiple build operations.
	 *
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface EnquiryStandbyTimeMillisBuilder<B extends EnquiryStandbyTimeMillisBuilder<B>> {

		/**
		 * Sets the number for the ENQ ("enquiry") timeout property.
		 * 
		 * @param aEnquiryStandbyTimeMillis The ENQ ("enquiry") timeout in
		 *        milliseconds to be stored by the ENQ ("enquiry") timeout
		 *        property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withEnquiryStandbyTimeMillis( long aEnquiryStandbyTimeMillis );
	}

	/**
	 * Provides a ENQ ("enquiry") timeout in milliseconds property.
	 */
	public interface EnquiryStandbyTimeMillisProperty extends EnquiryStandbyTimeMillisAccessor, EnquiryStandbyTimeMillisMutator {

		/**
		 * This method stores and passes through the given argument, which is
		 * very useful for builder APIs: Sets the given long (setter) as of
		 * {@link #setEnquiryStandbyTimeMillis(long)} and returns the very same
		 * value (getter).
		 * 
		 * @param aEnquiryStandbyTimeMillis The long to set (via
		 *        {@link #setEnquiryStandbyTimeMillis(long)}).
		 * 
		 * @return Returns the value passed for it to be used in conclusive
		 *         processing steps.
		 */
		default long letEnquiryStandbyTimeMillis( long aEnquiryStandbyTimeMillis ) {
			setEnquiryStandbyTimeMillis( aEnquiryStandbyTimeMillis );
			return aEnquiryStandbyTimeMillis;
		}
	}
}
