// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.serial;

import org.refcodes.mixin.AliasAccessor;

/**
 * Thrown in case there is no such port found.
 */
public class NoSuchPortExcpetion extends SerialException implements AliasAccessor {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String _alias;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 * 
	 * @param aAlias The alias of the port not detectable.
	 */
	public NoSuchPortExcpetion( String aAlias, String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
		_alias = aAlias;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @param aAlias The alias of the port not detectable.
	 */
	public NoSuchPortExcpetion( String aAlias, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
		_alias = aAlias;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @param aAlias The alias of the port not detectable.
	 */
	public NoSuchPortExcpetion( String aAlias, String message, Throwable cause ) {
		super( message, cause );
		_alias = aAlias;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @param aAlias The alias of the port not detectable.
	 */
	public NoSuchPortExcpetion( String aAlias, String message ) {
		super( message );
		_alias = aAlias;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @param aAlias The alias of the port not detectable.
	 */
	public NoSuchPortExcpetion( String aAlias, Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
		_alias = aAlias;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @param aAlias The alias of the port not detectable.
	 */
	public NoSuchPortExcpetion( String aAlias, Throwable cause ) {
		super( cause );
		_alias = aAlias;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getAlias() {
		return _alias;
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
