// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.serial;

/**
 * Provides an accessor for a {@link TransmissionMetrics} property.
 */
public interface TransmissionMetricsAccessor {

	/**
	 * Retrieves the name from the {@link TransmissionMetrics} property.
	 * 
	 * @return The name stored by the {@link TransmissionMetrics} property.
	 */
	TransmissionMetrics getTransmissionMetrics();

	/**
	 * Provides a mutator for a {@link TransmissionMetrics} property.
	 */
	public interface TransmissionMetricsMutator {

		/**
		 * Sets the name for the {@link TransmissionMetrics} property.
		 * 
		 * @param aTransmissionMetrics The name to be stored by the
		 *        {@link TransmissionMetrics} property.
		 */
		void setTransmissionMetrics( TransmissionMetrics aTransmissionMetrics );
	}

	/**
	 * Provides a builder method for a {@link TransmissionMetrics} property
	 * returning the builder for applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface TransmissionMetricsBuilder<B extends TransmissionMetricsBuilder<B>> {

		/**
		 * Sets the name for the {@link TransmissionMetrics} property.
		 * 
		 * @param aTransmissionMetrics The name to be stored by the
		 *        {@link TransmissionMetrics} property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withTransmissionMetrics( TransmissionMetrics aTransmissionMetrics );
	}

	/**
	 * Provides a {@link TransmissionMetrics} property.
	 */
	public interface TransmissionMetricsProperty extends TransmissionMetricsAccessor, TransmissionMetricsMutator {

		/**
		 * This method stores and passes through the given argument, which is
		 * very useful for builder APIs: Sets the given
		 * {@link TransmissionMetrics} (setter) as of
		 * {@link #setTransmissionMetrics(TransmissionMetrics)} and returns the
		 * very same value (getter).
		 * 
		 * @param aTransmissionMetrics The {@link TransmissionMetrics} to set
		 *        (via {@link #setTransmissionMetrics(TransmissionMetrics)}).
		 * 
		 * @return Returns the value passed for it to be used in conclusive
		 *         processing steps.
		 */
		default TransmissionMetrics letTransmissionMetrics( TransmissionMetrics aTransmissionMetrics ) {
			setTransmissionMetrics( aTransmissionMetrics );
			return aTransmissionMetrics;
		}
	}
}
