// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

/**
 * This toolkit targets at programming serial communication at a high
 * abstraction level, addressing issues such
 * <a href="https://en.wikipedia.org/wiki/Endianness">endianess</a>, length
 * allocations,
 * <a href="https://en.wikipedia.org/wiki/Cyclic_redundancy_check">CRC</a>
 * checksums, acknowledgement management or handshake processing whilst keeping
 * you in full control over your bits and bytes.
 * 
 * <p style="font-style: plain; font-weight: normal; background-color: #f8f8ff;
 * padding: 1.5rem; border-style: solid; border-width: 1pt; border-radius: 10pt;
 * border-color: #cccccc;text-align: center;">
 * Please refer to the <a href=
 * "https://www.metacodes.pro/refcodes/blog/refcodes-serial"><strong>refcodes-serial:
 * A serial communication toolkit for Java</strong></a> documentation for an
 * up-to-date and detailed description on the usage of this artifact.
 * </p>
 */
package org.refcodes.serial;