// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.serial;

import java.util.UUID;

/**
 * Provides base functionality to create {@link Port} instances. Override
 * methods to adjust the tests to different environments such as "loopback",
 * "tty" and so on.
 */
public class AbstractLoopbackPortTest {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private Port<?> _port1 = null;
	private Port<?> _port2 = null;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	protected boolean hasPorts() {
		return true;
	}

	protected Port<?> getReceiverPort() {
		return getReceiverPort( null );
	}

	protected Port<?> getReceiverPort( PortMetrics aPortMetrics ) {
		if ( _port1 == null ) {
			synchronized ( this ) {
				if ( _port1 == null ) {
					_port1 = new LoopbackPort( "/dev/ttyLoopback" + UUID.randomUUID().toString() );
				}
			}
		}
		return _port1;
	}

	protected Port<?> getTransmitterPort() {
		return getTransmitterPort( null );
	}

	protected Port<?> getTransmitterPort( PortMetrics aPortMetrics ) {
		if ( _port2 == null ) {
			synchronized ( this ) {
				if ( _port2 == null ) {
					_port2 = new CrossoverLoopbackPort( (LoopbackPort) getReceiverPort( aPortMetrics ) );
				}
			}
		}
		return _port2;
	}

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
