// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.serial;

import static org.junit.jupiter.api.Assertions.*;
import static org.refcodes.serial.SerialSugar.*;

import java.util.Arrays;

import org.junit.jupiter.api.Test;

public class DynamicTypeTest extends TestFixures {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	private static boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean( "log.test");

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Test
	public void testDynamicTypeSection1() throws TransmissionException {

		int[] theValues = new int[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( Arrays.toString( theValues ) );
		}

		// @formatter:off
		Segment theSegment = allocSegment(
			dynamicTypeSection( theValues )
		);
		// @formatter:on

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( theSegment.toSchema() );
		}

		Sequence theSequence = theSegment.toSequence();

		DynamicTypeSection theOtherDynamicSection;
		// @formatter:off
		Segment theOtherSegment = allocSegment(
			theOtherDynamicSection = dynamicTypeSection()
		);
		// @formatter:on
		theOtherSegment.fromTransmission( theSequence );

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( theOtherSegment.toSchema() );
		}
		int[] theOtherValues = theOtherDynamicSection.toType( int[].class );

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( Arrays.toString( theOtherValues ) );
		}

		assertArrayEquals( theValues, theOtherValues );
	}

	@Test
	public void testDynamicTypeSection2() throws TransmissionException {

		Values theValues = new Values();
		theValues._booleans = new boolean[] { true, false, true, false, true, false, true, false, true, false };
		theValues._bytes = new byte[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
		theValues._chars = new char[] { '1', '2', '3', '4', '5', '6', '7', '8', '9', '0' };
		theValues._shorts = new short[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
		theValues._ints = new int[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
		theValues._longs = new long[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
		theValues._floats = new float[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
		theValues._doubles = new double[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
		theValues._strings = new String[] { "1", "2", "3", "4", "5", "6", "7", "8", "9", "0" };

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( theValues );
		}

		DynamicTypeSegment theDynamicTypeSegment = dynamicTypeSegment( theValues );

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( theDynamicTypeSegment.toSchema() );
		}

		Sequence theSequence = theDynamicTypeSegment.toSequence();
		DynamicTypeSegment theOtherDynamicSegment = dynamicTypeSegment();
		theOtherDynamicSegment.fromTransmission( theSequence );

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( theOtherDynamicSegment.toSchema() );
		}

		Values theOtherValues = theOtherDynamicSegment.toType( Values.class );

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( theOtherValues );
		}

		assertEquals( theValues, theOtherValues );
	}

	@Test
	public void testDynamicTypeSegment1() throws TransmissionException {

		int[] theValues = new int[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( Arrays.toString( theValues ) );
		}

		DynamicTypeSegment theDynamicTypeSegment = dynamicTypeSegment( theValues );

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( theDynamicTypeSegment.toSchema() );
		}

		Sequence theSequence = theDynamicTypeSegment.toSequence();
		DynamicTypeSegment theOtherDynamicSegment = dynamicTypeSegment();
		theOtherDynamicSegment.fromTransmission( theSequence );

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( theOtherDynamicSegment.toSchema() );
		}
		int[] theOtherValues = theOtherDynamicSegment.toType( int[].class );

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( Arrays.toString( theOtherValues ) );
		}

		assertArrayEquals( theValues, theOtherValues );
	}

	@Test
	public void testDynamicTypeSegment2() throws TransmissionException {

		Values theValues = new Values();
		theValues._booleans = new boolean[] { true, false, true, false, true, false, true, false, true, false };
		theValues._bytes = new byte[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
		theValues._chars = new char[] { '1', '2', '3', '4', '5', '6', '7', '8', '9', '0' };
		theValues._shorts = new short[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
		theValues._ints = new int[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
		theValues._longs = new long[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
		theValues._floats = new float[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
		theValues._doubles = new double[] { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
		theValues._strings = new String[] { "1", "2", "3", "4", "5", "6", "7", "8", "9", "0" };

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( theValues );
		}

		// @formatter:off
		Segment theSegment = allocSegment(
			dynamicTypeSection( theValues )
		);
		// @formatter:on

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( theSegment.toSchema() );
		}

		Sequence theSequence = theSegment.toSequence();

		DynamicTypeSection theOtherDynamicSection;
		// @formatter:off
		Segment theOtherSegment = allocSegment(
			theOtherDynamicSection = dynamicTypeSection()
		);
		// @formatter:on
		theOtherSegment.fromTransmission( theSequence );

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( theOtherSegment.toSchema() );
		}

		Values theOtherValues = theOtherDynamicSection.toType( Values.class );

		if ( IS_LOG_TEST_ENABLED ) {
			System.out.println( theOtherValues );
		}

		assertEquals( theValues, theOtherValues );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
