// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.serial;

import static org.junit.jupiter.api.Assertions.*;
import static org.refcodes.serial.SerialSugar.*;

import java.io.IOException;

import org.junit.jupiter.api.Test;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.serial.TestFixures.WeatherData;

public class StopAndWaitTest extends AbstractLoopbackPortTest {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	private static boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean( "log.test");
	private static final int LOOPS = 3;

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Test stop and wait segment decorator 1.
	 *
	 * @throws TransmissionSequenceException the transmission sequence exception
	 * @throws IOException Signals that an I/O exception has occurred.
	 * @throws NoSuchPortExcpetion the no such port excpetion
	 * @throws InterruptedException the interrupted exception
	 */
	@Test
	public void testStopAndWaitSegmentDecorator1() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
		if ( hasPorts() ) {
			Port<?> theTransmitPort = getTransmitterPort().withOpen();
			Port<?> theReceiverPort = getReceiverPort().withOpen();
			WeatherData theSenderData = TestFixures.createWeatherData();
			ComplexTypeSegment<WeatherData> theReceiverComplexSegment;
			Segment theSenderSeg = stopAndWaitSegment( crcPrefixSegment( complexTypeSegment( theSenderData ), CrcAlgorithmConfig.CRC_16_CCITT_FALSE ) );
			Segment theReceiverSeg = stopAndWaitSegment( crcPrefixSegment( theReceiverComplexSegment = complexTypeSegment( WeatherData.class ), CrcAlgorithmConfig.CRC_16_CCITT_FALSE ) );

			for ( int i = 0; i < LOOPS; i++ ) {
				SegmentResult<Segment> theResult = theReceiverPort.onReceiveSegment( theReceiverSeg );
				theSenderSeg.transmitTo( theTransmitPort );
				theResult.waitForResult();

				WeatherData theReceiverData = theReceiverComplexSegment.getPayload();
				if ( IS_LOG_TEST_ENABLED ) {
					System.out.println( theReceiverData );
				}
				assertEquals( theSenderData, theReceiverData );
			}

			theTransmitPort.close();
			theReceiverPort.close();
		}
		else {
			System.out.println( "Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!" );
		}
	}

	/**
	 * Test stop and wait segment decorator 2.
	 *
	 * @throws TransmissionSequenceException the transmission sequence exception
	 * @throws IOException Signals that an I/O exception has occurred.
	 * @throws NoSuchPortExcpetion the no such port excpetion
	 * @throws InterruptedException the interrupted exception
	 */
	@Test
	public void testStopAndWaitSegmentDecorator2() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
		if ( hasPorts() ) {
			Port<?> theTransmitPort = getTransmitterPort().withOpen();
			Port<?> theReceiverPort = getReceiverPort().withOpen();
			WeatherData theSenderData = TestFixures.createWeatherData();
			ComplexTypeSegment<WeatherData> theReceiverComplexSegment;
			BreakerSegmentDecorator<?> theBreaker;
			Segment theSenderSeg = stopAndWaitSegment( crcPrefixSegment( complexTypeSegment( theSenderData ), CrcAlgorithmConfig.CRC_16_CCITT_FALSE ) );
			Segment theReceiverSeg = stopAndWaitSegment( theBreaker = breakerSegment( crcPrefixSegment( theReceiverComplexSegment = complexTypeSegment( WeatherData.class ), CrcAlgorithmConfig.CRC_16_CCITT_FALSE ), 3 ) );

			for ( int i = 0; i < LOOPS; i++ ) {
				SegmentResult<Segment> theResult = theReceiverPort.onReceiveSegment( theReceiverSeg );
				theSenderSeg.transmitTo( theTransmitPort );
				theResult.waitForResult();

				WeatherData theReceiverData = theReceiverComplexSegment.getPayload();
				if ( IS_LOG_TEST_ENABLED ) {
					System.out.println( theReceiverData );
				}
				assertEquals( theSenderData, theReceiverData );
				theBreaker.reset();
			}

			theTransmitPort.close();
			theReceiverPort.close();
		}
		else {
			System.out.println( "Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!" );
		}
	}

	/**
	 * Test stop and wait section decorator 1.
	 *
	 * @throws TransmissionSequenceException the transmission sequence exception
	 * @throws IOException Signals that an I/O exception has occurred.
	 * @throws NoSuchPortExcpetion the no such port excpetion
	 * @throws InterruptedException the interrupted exception
	 */
	@Test
	public void testStopAndWaitSectionDecorator1() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
		if ( hasPorts() ) {
			Port<?> theTransmitPort = getTransmitterPort().withOpen();
			Port<?> theReceiverPort = getReceiverPort().withOpen();
			String theSenderData = "The weather is good this morning. Temperature is about 20 degrees, some rain, much sun.";
			StringSection theReceiverSection;
			Segment theSenderSeg = crcPrefixSegment( allocSegment( stopAndWaitSection( stringSection( theSenderData ) ) ), CrcAlgorithmConfig.CRC_16_CCITT_FALSE );
			Segment theReceiverSeg = crcPrefixSegment( allocSegment( stopAndWaitSection( theReceiverSection = stringSection() ) ), CrcAlgorithmConfig.CRC_16_CCITT_FALSE );

			for ( int i = 0; i < LOOPS; i++ ) {
				SegmentResult<Segment> theResult = theReceiverPort.onReceiveSegment( theReceiverSeg );
				theSenderSeg.transmitTo( theTransmitPort );
				theResult.waitForResult();

				String theReceiverData = theReceiverSection.getPayload();
				if ( IS_LOG_TEST_ENABLED ) {
					System.out.println( theReceiverData );
				}
				assertEquals( theSenderData, theReceiverData );
			}

			theTransmitPort.close();
			theReceiverPort.close();
		}
		else {
			System.out.println( "Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!" );
		}
	}

	/**
	 * Test stop and wait section decorator 2.
	 *
	 * @throws TransmissionSequenceException the transmission sequence exception
	 * @throws IOException Signals that an I/O exception has occurred.
	 * @throws NoSuchPortExcpetion the no such port excpetion
	 * @throws InterruptedException the interrupted exception
	 */
	@Test
	public void testStopAndWaitSectionDecorator2() throws TransmissionSequenceException, IOException, NoSuchPortExcpetion, InterruptedException {
		if ( hasPorts() ) {
			Port<?> theTransmitPort = getTransmitterPort().withOpen();
			Port<?> theReceiverPort = getReceiverPort().withOpen();
			String theSenderData = "The weather is good this morning. Temperature is about 20 degrees, some rain, much sun.";
			StringSection theReceiverSection;
			BreakerSectionDecorator<?> theBreaker;
			Segment theSenderSeg = crcPrefixSegment( allocSegment( stopAndWaitSection( stringSection( theSenderData ) ) ), CrcAlgorithmConfig.CRC_16_CCITT_FALSE );
			Segment theReceiverSeg = crcPrefixSegment( allocSegment( stopAndWaitSection( theBreaker = breakerSection( theReceiverSection = stringSection(), 3 ) ) ), CrcAlgorithmConfig.CRC_16_CCITT_FALSE );

			for ( int i = 0; i < LOOPS; i++ ) {
				SegmentResult<Segment> theResult = theReceiverPort.onReceiveSegment( theReceiverSeg );
				theSenderSeg.transmitTo( theTransmitPort );
				theResult.waitForResult();

				String theReceiverData = theReceiverSection.getPayload();
				if ( IS_LOG_TEST_ENABLED ) {
					System.out.println( theReceiverData );
				}
				assertEquals( theSenderData, theReceiverData );
				theBreaker.reset();
			}

			theTransmitPort.close();
			theReceiverPort.close();
		}
		else {
			System.out.println( "Skipping test, please connect your null modem cable to two serial ports on your box, seeking for exactly two FT232 (ftdi_sio) type ports!" );
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
