// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.serial;

import java.io.IOException;

import org.refcodes.exception.IORuntimeException;

/**
 * A daemon handling
 * {@link SerialReceiver#onReceiveSegment(Segment, SegmentConsumer)}
 * asynchronous calls.
 *
 * @param <SEGMENT> The type of the {@link Segment} in question.
 */
public class ReceiveSegmentConsumerDaemon<SEGMENT extends Segment> implements Runnable {

	private final SegmentConsumer<SEGMENT> _segmentConsumer;
	private final SEGMENT _segment;
	private SerialTransceiver _serialTransceiver;

	/**
	 * Instantiates a new receive segment consumer daemon.
	 *
	 * @param aSegmentConsumer the segment consumer
	 * @param aSegment the segment
	 * @param aSerialTransceiver the serial transceiver
	 */
	public ReceiveSegmentConsumerDaemon( SegmentConsumer<SEGMENT> aSegmentConsumer, SEGMENT aSegment, SerialTransceiver aSerialTransceiver ) {
		_segmentConsumer = aSegmentConsumer;
		_segment = aSegment;
		_serialTransceiver = aSerialTransceiver;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() {
		try {
			_segment.receiveFrom( _serialTransceiver );
			_segmentConsumer.onSegment( _segment );
		}
		catch ( IOException e ) {
			throw new IORuntimeException( "Unable to receive segment as of: " + e.getMessage(), e );
		}
	}
}