/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.refcodes.factory.ClassTypeFactory;
import org.refcodes.factory.TypeFactory;
import org.refcodes.mixin.Schema;
import org.refcodes.serial.ArrayTransmission;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.Transmission;

public abstract class AbstractArrayTransmission<ARRAY extends Transmission>
implements Transmission,
ArrayTransmission<ARRAY> {
    private static final long serialVersionUID = 1L;
    protected ARRAY[] _array;
    protected TypeFactory<ARRAY> _sequenceableFactory;
    protected String _alias;

    public AbstractArrayTransmission(ARRAY ... aSegments) {
        this(null, (Transmission[])aSegments);
    }

    public AbstractArrayTransmission(Collection<ARRAY> aSegments) {
        this((String)null, aSegments);
    }

    public AbstractArrayTransmission(TypeFactory<ARRAY> aSegmentFactory, ARRAY ... aSegments) {
        this(null, (TypeFactory)aSegmentFactory, (Transmission[])aSegments);
    }

    public AbstractArrayTransmission(TypeFactory<ARRAY> aSegmentFactory, Collection<ARRAY> aSegments) {
        this((String)null, aSegmentFactory, aSegments);
    }

    public AbstractArrayTransmission(TypeFactory<ARRAY> aSegmentFactory) {
        this((String)null, aSegmentFactory);
    }

    public AbstractArrayTransmission(Class<ARRAY> aSegmentClass) {
        this((String)null, aSegmentClass);
    }

    public AbstractArrayTransmission(String aAlias, ARRAY ... aSegments) {
        this._sequenceableFactory = new ClassTypeFactory(aSegments.getClass().getComponentType());
        this._array = aSegments;
        this._alias = aAlias;
    }

    public AbstractArrayTransmission(String aAlias, Collection<ARRAY> aSegments) {
        this(aAlias, aSegments.toArray(new Segment[aSegments.size()]));
    }

    public AbstractArrayTransmission(String aAlias, TypeFactory<ARRAY> aSegmentFactory, ARRAY ... aSegments) {
        this._sequenceableFactory = aSegmentFactory;
        this._array = aSegments;
        this._alias = aAlias;
    }

    public AbstractArrayTransmission(String aAlias, TypeFactory<ARRAY> aSegmentFactory, Collection<ARRAY> aSegments) {
        this(aAlias, aSegmentFactory, aSegments.toArray(new Segment[aSegments.size()]));
    }

    public AbstractArrayTransmission(String aAlias, TypeFactory<ARRAY> aSegmentFactory) {
        this._sequenceableFactory = aSegmentFactory;
        this._array = (Transmission[])Array.newInstance(aSegmentFactory.getType(), 0);
        this._alias = aAlias;
    }

    public AbstractArrayTransmission(String aAlias, Class<ARRAY> aSegmentClass) {
        this._sequenceableFactory = new ClassTypeFactory(aSegmentClass);
        this._array = (Transmission[])Array.newInstance(aSegmentClass, 0);
        this._alias = aAlias;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema[] theSchemas = null;
        if (this._array != null && this._array.length != 0) {
            theSchemas = new SerialSchema[this._array.length];
            for (int i = 0; i < theSchemas.length; ++i) {
                theSchemas[i] = this._array[i].toSchema();
            }
        }
        return new SerialSchema(this.getClass(), this.toSequence(), this.getLength(), "An array segment containing a fixed length elements array as payload.", (Schema[])theSchemas);
    }

    @Override
    public int getLength() {
        int theLength = 0;
        if (this._array != null) {
            for (int i = 0; i < this._array.length; ++i) {
                theLength += this._array[i].getLength();
            }
        }
        return theLength;
    }

    public ARRAY[] getArray() {
        return this._array;
    }

    public void setArray(ARRAY[] aValue) {
        this._array = aValue;
    }

    public AbstractArrayTransmission<ARRAY> withArray(ARRAY[] aValue) {
        this.setArray((Transmission[])aValue);
        return this;
    }

    public String getAlias() {
        return this._alias;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [array=" + Arrays.toString(this._array) + ", segmentFactory=" + this._sequenceableFactory + "]";
    }
}

