/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.refcodes.exception.BugException;
import org.refcodes.mixin.Schema;
import org.refcodes.serial.AbstractTransmissionDecorator;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceOutputStream;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.Transmission;

public abstract class AbstractCipherTransmissionDecorator<DECORATEE extends Transmission>
extends AbstractTransmissionDecorator<DECORATEE> {
    private static final long serialVersionUID = 1L;
    protected Cipher _cipher;

    public AbstractCipherTransmissionDecorator(DECORATEE aDecoratee, Cipher aCipher) {
        super(aDecoratee);
        this._cipher = aCipher;
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        CipherOutputStream theCipherOutputStream = new CipherOutputStream(aOutputStream, this._cipher);
        CipherInputStream theCipherInputStream = aReturnStream != null ? new CipherInputStream(aReturnStream, this._cipher) : null;
        this._decoratee.transmitTo(theCipherOutputStream, theCipherInputStream);
    }

    @Override
    public Sequence toSequence() {
        SequenceOutputStream theSequenceInputStream = new SequenceOutputStream();
        try {
            this.transmitTo(theSequenceInputStream);
        }
        catch (IOException e) {
            throw new BugException(e.getMessage(), (Throwable)e);
        }
        return theSequenceInputStream.getSequence();
    }

    @Override
    public SerialSchema toSchema() {
        return new SerialSchema(this.getClass(), this.toSequence(), this.getLength(), "A transmission decorator enriching the encapsulated transmission with \"Encryption\" as well as \"Decryption\" functionality (cypher).", new Schema[]{this.getDecoratee().toSchema()});
    }
}

