/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.mixin.Schema;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractReferenceeLengthSegment;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.DecoratorSegment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionMetrics;

public abstract class AbstractLengthDecoratorSegment<DECORATEE extends Transmission>
extends AbstractReferenceeLengthSegment<DECORATEE>
implements DecoratorSegment<DECORATEE> {
    private static final long serialVersionUID = 1L;

    protected AbstractLengthDecoratorSegment(TransmissionMetrics aTransmissionMetrics) {
        super(aTransmissionMetrics);
    }

    public AbstractLengthDecoratorSegment(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        super(aDecoratee, aTransmissionMetrics);
    }

    protected AbstractLengthDecoratorSegment() {
    }

    protected AbstractLengthDecoratorSegment(Endianess aEndianess) {
        super(aEndianess);
    }

    protected AbstractLengthDecoratorSegment(int aLengthWidth) {
        super(aLengthWidth);
    }

    protected AbstractLengthDecoratorSegment(int aLengthWidth, Endianess aEndianess) {
        super(aLengthWidth, aEndianess);
    }

    public AbstractLengthDecoratorSegment(DECORATEE aDecoratee) {
        super(aDecoratee);
    }

    public AbstractLengthDecoratorSegment(DECORATEE aDecoratee, Endianess aEndianess) {
        super(aDecoratee, aEndianess);
    }

    public AbstractLengthDecoratorSegment(DECORATEE aDecoratee, int aLengthWidth) {
        super(aDecoratee, aLengthWidth);
    }

    public AbstractLengthDecoratorSegment(DECORATEE aDecoratee, int aLengthWidth, Endianess aEndianess) {
        super(aDecoratee, aLengthWidth, aEndianess);
    }

    @Override
    public Sequence toSequence() {
        if (this._referencee == null) {
            this._allocLength = 0;
            return new ByteArraySequence(this._endianess.toBytes(this._allocLength, this._lengthWidth));
        }
        assert (this._referencee.toSequence().getLength() == this._referencee.getLength()) : "Bad length determination: Sequence length <" + this._referencee.toSequence().getLength() + "> does not match the segment length <" + this._referencee.getLength() + ">";
        this._allocLength = this._referencee.getLength();
        return new ByteArraySequence(this._endianess.toBytes(this._allocLength, this._lengthWidth)).withAppend(this._referencee.toSequence());
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        int theLength = this._referencee == null ? 0 : this._referencee.getLength();
        byte[] theBuffer = this._endianess.toUnsignedBytes((long)theLength, this._lengthWidth);
        aOutputStream.write(theBuffer);
        if (this._referencee != null) {
            this._referencee.transmitTo(aOutputStream, aReturnStream);
        }
    }

    @Override
    public int getLength() {
        return this._lengthWidth + (this._referencee != null ? this._referencee.getLength() : 0);
    }

    public DECORATEE getDecoratee() {
        return (DECORATEE)this._referencee;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getClass(), this.toSequence(), this.getLength(), "An allocation decorator referencing a decoratee and prefixing the length of the decoratee in bytes.", new Schema[]{this._referencee != null ? this._referencee.toSchema() : null});
        theSchema.put("ENDIANESS", this._endianess);
        theSchema.put("ALLOC_LENGTH_WIDTH", this._lengthWidth);
        theSchema.put("ALLOC_LENGTH", this._allocLength);
        return theSchema;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [endianess=" + this._endianess + ", lengthWidth=" + this._lengthWidth + ", allocLength=" + this._allocLength + ", segment=" + this._referencee + "]";
    }
}

