/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.exception.TimeoutIOException;
import org.refcodes.io.SkipAvailableInputStream;
import org.refcodes.io.TimeoutInputStream;
import org.refcodes.mixin.DecorateeAccessor;
import org.refcodes.mixin.Schema;
import org.refcodes.serial.FlowControlException;
import org.refcodes.serial.FlowControlRetryException;
import org.refcodes.serial.FlowControlTimeoutException;
import org.refcodes.serial.MagicBytesSegment;
import org.refcodes.serial.ReadyToSendTransmission;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.SerialUtility;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapImpl;

public abstract class AbstractReadyToSendTransmissionDecorator<DECORATEE extends Transmission>
implements ReadyToSendTransmission,
Transmission.TransmissionMixin,
DecorateeAccessor<DECORATEE> {
    private static final long serialVersionUID = 1L;
    public static final String RTS_MAGIC_BYTES = "RTS_MAGIC_BYTES";
    public static final String RTS_TIMEOUT_IN_MS = "RTS_TIMEOUT_IN_MS";
    public static final String RTS_RETRY_NUMBER = "RTS_RETRY_NUMBER";
    public static final String CTS_MAGIC_BYTES = "CTS_MAGIC_BYTES";
    public static final String CTS_TIMEOUT_IN_MS = "CTS_TIMEOUT_IN_MS";
    protected DECORATEE _decoratee = null;
    protected long _enquiryStandbyTimeInMs;
    protected long _clearToSendTimeoutInMs;
    protected byte[] _clearToSendMagicBytes;
    protected MagicBytesSegment _clearToSendMagicBytesSegment;
    protected Segment _clearToSendSegment;
    protected SegmentPackager _clearToSendSegmentPackager;
    protected long _readyToSendTimeoutInMs;
    protected byte[] _readyToSendMagicBytes;
    protected SegmentPackager _readyToSendSegmentPackager;
    protected int _readyToSendRetryNumber;
    protected MagicBytesSegment _readyToSendMagicBytesSegment;
    protected Segment _readyToSendSegment;

    protected AbstractReadyToSendTransmissionDecorator() {
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        this(aDecoratee, aTransmissionMetrics.getEnquiryStandbyTimeMillis(), aTransmissionMetrics.getReadyToSendMagicBytes(), aTransmissionMetrics.getReadyToSendRetryNumber(), aTransmissionMetrics.getReadyToSendTimeoutMillis(), aTransmissionMetrics.getReadyToSendSegmentPackager(), aTransmissionMetrics.getClearToSendMagicBytes(), aTransmissionMetrics.getClearToSendTimeoutMillis(), aTransmissionMetrics.getClearToSendSegmentPackager());
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee) {
        this(aDecoratee, -1L, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, null, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_MAGIC_BYTES, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS, null);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, byte[] aClearToSendMagicBytes) {
        this(aDecoratee, -1L, aReadyToSendMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, null, aClearToSendMagicBytes, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS, null);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, null, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_MAGIC_BYTES, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS, null);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, SegmentPackager aClearToSendSegmentPackager) {
        this(aDecoratee, -1L, aReadyToSendMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, aReadyToSendSegmentPackager, aClearToSendMagicBytes, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS, aClearToSendSegmentPackager);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        this(aDecoratee, -1L, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_MAGIC_BYTES, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, int aReadyToSendRetryNumber, byte[] aClearToSendMagicBytes) {
        this(aDecoratee, -1L, aReadyToSendMagicBytes, aReadyToSendRetryNumber, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, null, aClearToSendMagicBytes, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS, null);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, int aReadyToSendRetryNumber, long aReadyToSendTimeoutInMs, long aClearToSendTimeoutInMs) {
        this(aDecoratee, -1L, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, aReadyToSendRetryNumber, aReadyToSendTimeoutInMs, null, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_MAGIC_BYTES, aClearToSendTimeoutInMs, null);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, int aReadyToSendRetryNumber, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, SegmentPackager aClearToSendSegmentPackager) {
        this(aDecoratee, -1L, aReadyToSendMagicBytes, aReadyToSendRetryNumber, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, aReadyToSendSegmentPackager, aClearToSendMagicBytes, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS, aClearToSendSegmentPackager);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, int aReadyToSendRetryNumber, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        this(aDecoratee, -1L, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, aReadyToSendRetryNumber, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_MAGIC_BYTES, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, long aReadyToSendTimeoutInMs, byte[] aClearToSendMagicBytes, long aClearToSendTimeoutInMs) {
        this(aDecoratee, -1L, aReadyToSendMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToSendTimeoutInMs, null, aClearToSendMagicBytes, aClearToSendTimeoutInMs, null);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        this(aDecoratee, -1L, aReadyToSendMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, aClearToSendMagicBytes, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, byte[] aClearToSendMagicBytes) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, null, aClearToSendMagicBytes, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS, null);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, long aReadyToSendTimeoutInMs, long aClearToSendTimeoutInMs) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToSendTimeoutInMs, null, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_MAGIC_BYTES, aClearToSendTimeoutInMs, null);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, SegmentPackager aClearToSendSegmentPackager) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, aReadyToSendSegmentPackager, aClearToSendMagicBytes, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS, aClearToSendSegmentPackager);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_MAGIC_BYTES, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, int aReadyToSendRetryNumber, byte[] aClearToSendMagicBytes) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendMagicBytes, aReadyToSendRetryNumber, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, null, aClearToSendMagicBytes, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS, null);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, int aReadyToSendRetryNumber, long aReadyToSendTimeoutInMs, long aClearToSendTimeoutInMs) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, aReadyToSendRetryNumber, aReadyToSendTimeoutInMs, null, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_MAGIC_BYTES, aClearToSendTimeoutInMs, null);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, int aReadyToSendRetryNumber, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, SegmentPackager aClearToSendSegmentPackager) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendMagicBytes, aReadyToSendRetryNumber, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_TIMEOUT_IN_MS, aReadyToSendSegmentPackager, aClearToSendMagicBytes, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_TIMEOUT_IN_MS, aClearToSendSegmentPackager);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, int aReadyToSendRetryNumber, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_MAGIC_BYTES, aReadyToSendRetryNumber, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, TransmissionMetrics.DEFAULT_CLEAR_TO_SEND_MAGIC_BYTES, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, long aReadyToSendTimeoutInMs, byte[] aClearToSendMagicBytes, long aClearToSendTimeoutInMs) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToSendTimeoutInMs, null, aClearToSendMagicBytes, aClearToSendTimeoutInMs, null);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        this(aDecoratee, aEnquiryStandbyTimeInMs, aReadyToSendMagicBytes, TransmissionMetrics.DEFAULT_READY_TO_RECEIVE_RETRY_NUMBER, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, aClearToSendMagicBytes, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, byte[] aReadyToSendMagicBytes, int aReadyToSendRetryNumber, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        this(aDecoratee, -1L, aReadyToSendMagicBytes, aReadyToSendRetryNumber, aReadyToSendTimeoutInMs, aReadyToSendSegmentPackager, aClearToSendMagicBytes, aClearToSendTimeoutInMs, aClearToSendSegmentPackager);
    }

    public AbstractReadyToSendTransmissionDecorator(DECORATEE aDecoratee, long aEnquiryStandbyTimeInMs, byte[] aReadyToSendMagicBytes, int aReadyToSendRetryNumber, long aReadyToSendTimeoutInMs, SegmentPackager aReadyToSendSegmentPackager, byte[] aClearToSendMagicBytes, long aClearToSendTimeoutInMs, SegmentPackager aClearToSendSegmentPackager) {
        this._decoratee = aDecoratee;
        this._enquiryStandbyTimeInMs = aEnquiryStandbyTimeInMs;
        this._readyToSendMagicBytes = aReadyToSendMagicBytes;
        this._readyToSendRetryNumber = aReadyToSendRetryNumber;
        this._readyToSendTimeoutInMs = aReadyToSendTimeoutInMs;
        this._readyToSendSegmentPackager = aReadyToSendSegmentPackager != null ? aReadyToSendSegmentPackager : new SegmentPackager.DummySegmentPackager();
        this._readyToSendMagicBytesSegment = new MagicBytesSegment(this._readyToSendMagicBytes);
        this._readyToSendSegment = this._readyToSendSegmentPackager.toPackaged(this._readyToSendMagicBytesSegment);
        this._clearToSendMagicBytes = aClearToSendMagicBytes;
        this._clearToSendTimeoutInMs = aClearToSendTimeoutInMs;
        this._clearToSendSegmentPackager = aClearToSendSegmentPackager != null ? aClearToSendSegmentPackager : new SegmentPackager.DummySegmentPackager();
        this._clearToSendMagicBytesSegment = new MagicBytesSegment(this._clearToSendMagicBytes);
        this._clearToSendSegment = this._clearToSendSegmentPackager.toPackaged(this._clearToSendMagicBytesSegment);
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        if (aReturnStream != null) {
            RetryCounter theRetries = new RetryCounter(this._readyToSendRetryNumber, this._readyToSendTimeoutInMs);
            Exception eException = null;
            SkipAvailableInputStream theSkipReturnStream = new SkipAvailableInputStream(aReturnStream, this._readyToSendTimeoutInMs);
            while (theRetries.nextRetry()) {
                theSkipReturnStream.skipAvailableExcept(this._clearToSendSegment.getLength());
                eException = null;
                try {
                    this._readyToSendSegment.transmitTo(aOutputStream);
                    this.receiveCtsTransmitTo(aOutputStream, aReturnStream);
                    return;
                }
                catch (Exception e) {
                    eException = e;
                }
            }
            if (eException != null) {
                if (eException instanceof FlowControlException) {
                    throw (FlowControlException)((Object)eException);
                }
                throw new FlowControlRetryException(this._readyToSendRetryNumber, this._readyToSendTimeoutInMs, "Aborting after <" + this._readyToSendRetryNumber + "> retries with a timeout for each retry of <" + this._readyToSendTimeoutInMs + "> milliseconds: " + eException.getMessage(), eException);
            }
            throw new FlowControlRetryException(this._readyToSendRetryNumber, this._readyToSendTimeoutInMs, "Aborting after <" + this._readyToSendRetryNumber + "> retries with a timeout for each retry of <" + this._readyToSendTimeoutInMs + "> milliseconds.");
        }
        this._decoratee.transmitTo(aOutputStream, aReturnStream);
    }

    protected void receiveCtsTransmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException, TransmissionException, FlowControlTimeoutException {
        long theReadyToSendTimeoutInMs = this._readyToSendTimeoutInMs;
        long theBeginTimeInMs = System.currentTimeMillis();
        TimeoutInputStream theTimeoutReturnStream = SerialUtility.createTimeoutInputStream(aReturnStream, theReadyToSendTimeoutInMs);
        while (theReadyToSendTimeoutInMs == -1L || theReadyToSendTimeoutInMs > 0L) {
            try {
                this._clearToSendSegment.receiveFrom((InputStream)theTimeoutReturnStream);
            }
            catch (TimeoutIOException e) {
                throw new FlowControlTimeoutException(e.getTimeoutInMs(), e.getMessage(), e);
            }
            if (Arrays.equals(this._clearToSendMagicBytesSegment.getPayload(), this._clearToSendMagicBytes)) {
                this._decoratee.transmitTo(aOutputStream, aReturnStream);
                return;
            }
            if (theReadyToSendTimeoutInMs == -1L) continue;
            long eCurrentTimeInMs = System.currentTimeMillis();
            long ePassedTimeInMs = eCurrentTimeInMs - theBeginTimeInMs;
            theBeginTimeInMs = eCurrentTimeInMs;
            if (ePassedTimeInMs < theReadyToSendTimeoutInMs) {
                theReadyToSendTimeoutInMs -= ePassedTimeInMs;
                continue;
            }
            throw new FlowControlTimeoutException(this._clearToSendTimeoutInMs, "Failed after a timeout of <" + this._clearToSendTimeoutInMs + "> as the current (transmitter) CTS byte <" + this._clearToSendMagicBytesSegment.getPayload() + "> does not match the expected CTS byte <" + this._clearToSendMagicBytes + ">.");
        }
        throw new FlowControlTimeoutException(this._clearToSendTimeoutInMs, "Failed after a timeout of <" + this._clearToSendTimeoutInMs + "> as the current (received) RTS byte <" + this._clearToSendMagicBytesSegment.getPayload() + "> does not match the expected RTS byte <" + this._clearToSendMagicBytes + ">.");
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getClass(), this.toSequence(), this.getLength(), "A transmission decorator enriching the encapsulated transmission with \"Ready-to-send RTS\".", new Schema[]{this.getDecoratee().toSchema()});
        theSchema.put(RTS_MAGIC_BYTES, this.getReadyToSendMagicBytes());
        theSchema.put(RTS_TIMEOUT_IN_MS, this.getReadyToSendTimeoutMillis());
        theSchema.put(RTS_RETRY_NUMBER, this.getReadyToSendRetryNumber());
        theSchema.put(CTS_MAGIC_BYTES, this.getClearToSendMagicBytes());
        theSchema.put(CTS_TIMEOUT_IN_MS, this.getClearToSendTimeoutMillis());
        return theSchema;
    }

    @Override
    public long getEnquiryStandbyTimeMillis() {
        return this._enquiryStandbyTimeInMs;
    }

    @Override
    public long getReadyToSendTimeoutMillis() {
        return this._readyToSendTimeoutInMs;
    }

    @Override
    public byte[] getReadyToSendMagicBytes() {
        return this._readyToSendMagicBytes;
    }

    @Override
    public int getReadyToSendRetryNumber() {
        return this._readyToSendRetryNumber;
    }

    @Override
    public SegmentPackager getReadyToSendSegmentPackager() {
        return this._readyToSendSegmentPackager;
    }

    @Override
    public byte[] getClearToSendMagicBytes() {
        return this._clearToSendMagicBytes;
    }

    @Override
    public long getClearToSendTimeoutMillis() {
        return this._clearToSendTimeoutInMs;
    }

    @Override
    public SegmentPackager getClearToSendSegmentPackager() {
        return this._clearToSendSegmentPackager;
    }

    @Override
    public int getLength() {
        return this._decoratee.getLength();
    }

    @Override
    public Sequence toSequence() {
        return this._decoratee.toSequence();
    }

    public DECORATEE getDecoratee() {
        return this._decoratee;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [segment=" + this._decoratee + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._decoratee == null ? 0 : this._decoratee.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractReadyToSendTransmissionDecorator other = (AbstractReadyToSendTransmissionDecorator)obj;
        return !(this._decoratee == null ? other._decoratee != null : !this._decoratee.equals(other._decoratee));
    }

    @Override
    public SimpleTypeMap toSimpleTypeMap() {
        return this._decoratee != null ? this._decoratee.toSimpleTypeMap() : new SimpleTypeMapImpl();
    }
}

