/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.mixin.DecorateeAccessor;
import org.refcodes.mixin.PacketSizeAccessor;
import org.refcodes.mixin.Schema;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.StopAndWaitPacketOutputStream;
import org.refcodes.serial.StopAndWaitPacketStreamTransmission;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapImpl;

public abstract class AbstractStopAndWaitPacketStreamTransmissionDecorator<DECORATEE extends Transmission>
implements Transmission.TransmissionMixin,
StopAndWaitPacketStreamTransmission,
DecorateeAccessor<DECORATEE>,
PacketSizeAccessor {
    private static final long serialVersionUID = 1L;
    public static final String ENDIANESS = "ENDIANESS";
    public static final String SEQUENCE_NUMBER_WIDTH = "SEQUENCE_NUMBER_WIDTH";
    public static final String SEQUENCE_NUMBER_INIT_VALUE = "SEQUENCE_NUMBER_INIT_VALUE";
    public static final String BLOCK_SIZE = "BLOCK_SIZE";
    public static final String ACK_MAGIC_BYTES = "ACK_MAGIC_BYTES";
    public static final String ACK_TIMEOUT_IN_MS = "ACK_TIMEOUT_IN_MS";
    public static final String ACK_RETRY_NUMBER = "ACK_RETRY_NUMBER";
    protected DECORATEE _decoratee;
    protected int _blockSize;
    protected byte[] _acknowledgeMagicBytes;
    protected int _acknowledgeRetryNumber;
    protected long _acknowledgeTimeoutInMs;
    protected long _crcChecksum = -1L;
    protected Endianess _endianess;
    protected int _sequenceNumberWidth;
    protected int _sequenceNumberInitValue;
    protected ConcatenateMode _sequenceNumberConcatenateMode;
    protected SegmentPackager _acknowledgeSegmentPackager;
    protected SegmentPackager _packetSegmentPackager;
    protected int _packetSize = -1;
    protected byte[] _lastPacketMagicBytes = TransmissionMetrics.DEFAULT_LAST_PACKET_MAGIC_BYTES;
    protected byte[] _packetMagicBytes = TransmissionMetrics.DEFAULT_PACKET_MAGIC_BYTES;
    protected int _packetLengthWidth = 4;

    public AbstractStopAndWaitPacketStreamTransmissionDecorator(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        this(aDecoratee, aTransmissionMetrics.getBlockSize(), aTransmissionMetrics.getPacketLengthWidth(), aTransmissionMetrics.getPacketMagicBytes(), aTransmissionMetrics.getSequenceNumberInitValue(), aTransmissionMetrics.getSequenceNumberWidth(), aTransmissionMetrics.getSequenceNumberConcatenateMode(), aTransmissionMetrics.toPacketSegmentPackager(), aTransmissionMetrics.getAcknowledgeMagicBytes(), aTransmissionMetrics.getAcknowledgeRetryNumber(), aTransmissionMetrics.getAcknowledgeTimeoutMillis(), aTransmissionMetrics.toAckSegmentPackager(), aTransmissionMetrics.getEndianess());
    }

    public AbstractStopAndWaitPacketStreamTransmissionDecorator(DECORATEE aDecoratee, int aBlockSize, int aPacketLengthWidth, byte[] aPacketMagicBytes, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, SegmentPackager aPacketSegmentPackager, byte[] aAcknowledgeMagicBytes, int aAcknowledgeRetryNumber, long aAcknowledgeTimeoutInMs, SegmentPackager aAckSegmentPackager, Endianess aEndianess) {
        this._decoratee = aDecoratee;
        this._acknowledgeMagicBytes = aAcknowledgeMagicBytes;
        this._acknowledgeRetryNumber = aAcknowledgeRetryNumber;
        this._acknowledgeTimeoutInMs = aAcknowledgeTimeoutInMs;
        this._sequenceNumberConcatenateMode = aSequenceNumberConcatenateMode;
        this._sequenceNumberInitValue = aSequenceNumberInitValue;
        this._sequenceNumberWidth = aSequenceNumberWidth;
        this._blockSize = aBlockSize;
        this._endianess = aEndianess;
        this._packetMagicBytes = aPacketMagicBytes;
        this._packetLengthWidth = aPacketLengthWidth;
        this._acknowledgeSegmentPackager = aAckSegmentPackager != null ? aAckSegmentPackager : new SegmentPackager.DummySegmentPackager();
        this._packetSegmentPackager = aPacketSegmentPackager != null ? aPacketSegmentPackager : new SegmentPackager.DummySegmentPackager();
    }

    public ConcatenateMode getCrcChecksumConcatenateMode() {
        return this._sequenceNumberConcatenateMode;
    }

    public int getSequenceNumberWidth() {
        return this._sequenceNumberWidth;
    }

    public int getBlockSize() {
        return this._blockSize;
    }

    public int getPacketSize() {
        return this._packetSize - 1;
    }

    @Override
    public int getLength() {
        return this._decoratee.getLength();
    }

    public DECORATEE getDecoratee() {
        return this._decoratee;
    }

    public Endianess getEndianess() {
        return this._endianess;
    }

    @Override
    public int getSequenceNumberInitValue() {
        return this._sequenceNumberInitValue;
    }

    @Override
    public int getAcknowledgeRetryNumber() {
        return this._acknowledgeRetryNumber;
    }

    @Override
    public byte[] getAcknowledgeMagicBytes() {
        return this._acknowledgeMagicBytes;
    }

    @Override
    public SegmentPackager getAcknowledgeSegmentPackager() {
        return this._acknowledgeSegmentPackager;
    }

    @Override
    public long getAcknowledgeTimeoutMillis() {
        return this._acknowledgeTimeoutInMs;
    }

    @Override
    public Sequence toSequence() {
        return this._decoratee.toSequence();
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        StopAndWaitPacketOutputStream theBlockOutputStream = new StopAndWaitPacketOutputStream(aOutputStream, this._blockSize, this._packetLengthWidth, this._packetMagicBytes, this._sequenceNumberInitValue, this._sequenceNumberWidth, this._sequenceNumberConcatenateMode, this._packetSegmentPackager, aReturnStream, this._acknowledgeMagicBytes, this._acknowledgeRetryNumber, this._acknowledgeTimeoutInMs, this._acknowledgeSegmentPackager, this._endianess);
        this._packetSize = theBlockOutputStream.getPacketSize();
        this._decoratee.transmitTo(theBlockOutputStream);
        theBlockOutputStream.flush();
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getClass(), this.toSequence(), this.getLength(), "A segment decorator enriching the encapsulated segment's streams with packet functionality.", new Schema[]{this.getDecoratee().toSchema()});
        theSchema.put(ENDIANESS, this.getEndianess());
        theSchema.put(BLOCK_SIZE, this.getBlockSize());
        theSchema.put(SEQUENCE_NUMBER_INIT_VALUE, this.getSequenceNumberInitValue());
        theSchema.put(SEQUENCE_NUMBER_WIDTH, this.getSequenceNumberWidth());
        theSchema.put(ACK_MAGIC_BYTES, this.getAcknowledgeMagicBytes());
        theSchema.put(ACK_TIMEOUT_IN_MS, this.getAcknowledgeTimeoutMillis());
        theSchema.put(ACK_RETRY_NUMBER, this.getAcknowledgeRetryNumber());
        return theSchema;
    }

    @Override
    public SimpleTypeMap toSimpleTypeMap() {
        return this._decoratee != null ? this._decoratee.toSimpleTypeMap() : new SimpleTypeMapImpl();
    }
}

