/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.IoTimeout;
import org.refcodes.exception.BugException;
import org.refcodes.io.SkipAvailableInputStream;
import org.refcodes.io.TimeoutInputStream;
import org.refcodes.mixin.ConcatenateMode;
import org.refcodes.mixin.Schema;
import org.refcodes.numerical.ChecksumValidationMode;
import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.EndianessAccessor;
import org.refcodes.serial.AbstractErrorCorrectionTransmissionDecorator;
import org.refcodes.serial.CrcSegmentPackager;
import org.refcodes.serial.FlowControlException;
import org.refcodes.serial.FlowControlRetryException;
import org.refcodes.serial.MagicBytesSegment;
import org.refcodes.serial.NumberSegment;
import org.refcodes.serial.Segment;
import org.refcodes.serial.SegmentComposite;
import org.refcodes.serial.SegmentPackager;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceNumberAccessor;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.SerialUtility;
import org.refcodes.serial.StopAndWaitTransmission;
import org.refcodes.serial.Transmission;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.struct.SimpleTypeMap;
import org.refcodes.struct.SimpleTypeMapImpl;

public abstract class AbstractStopAndWaitTransmissionDecorator<DECORATEE extends Transmission>
extends AbstractErrorCorrectionTransmissionDecorator<DECORATEE>
implements StopAndWaitTransmission,
Transmission.TransmissionMixin,
EndianessAccessor,
SequenceNumberAccessor {
    private static final long serialVersionUID = 1L;
    public static final String ACK_MAGIC_BYTES = "ACK_MAGIC_BYTES";
    protected byte[] _acknowledgeMagicBytes;
    protected int _sequenceNumber;
    protected int _sequenceNumberWidth;
    protected int _sequenceNumberInitValue;
    protected ConcatenateMode _sequenceNumberConcatenateMode;
    protected Endianess _endianess;
    protected SegmentPackager _acknowledgeSegmentPackager;
    protected Segment _acknowledgeSegment;
    protected NumberSegment _acknowledgeSequenceNumberSegment;
    protected MagicBytesSegment _acknowledgeMagicBytesSegment;

    protected AbstractStopAndWaitTransmissionDecorator() {
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, TransmissionMetrics aTransmissionMetrics) {
        this(aDecoratee, aTransmissionMetrics.getSequenceNumberInitValue(), aTransmissionMetrics.getSequenceNumberWidth(), aTransmissionMetrics.getSequenceNumberConcatenateMode(), aTransmissionMetrics.getAcknowledgeMagicBytes(), aTransmissionMetrics.getAcknowledgeRetryNumber(), aTransmissionMetrics.getAcknowledgeTimeoutMillis(), aTransmissionMetrics.toAckSegmentPackager(), aTransmissionMetrics.getEndianess());
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee) {
        this(aDecoratee, -1, 4, TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, (SegmentPackager)null, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, Endianess aEndianess) {
        this(aDecoratee, -1, 4, TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, (SegmentPackager)null, aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, Endianess aEndianess) {
        this(aDecoratee, -1, 4, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, (SegmentPackager)null, aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, Endianess aEndianess) {
        this(aDecoratee, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, (SegmentPackager)null, aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, SegmentPackager aAckSegmentPackager) {
        this(aDecoratee, -1, 4, TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, aAckSegmentPackager, TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, SegmentPackager aAckSegmentPackager, Endianess aEndianess) {
        this(aDecoratee, -1, 4, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aAckSegmentPackager, aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, SegmentPackager aAckSegmentPackager, Endianess aEndianess) {
        this(aDecoratee, -1, 4, TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, aAckSegmentPackager, aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, ConcatenateMode aCrcChecksumConcatenateMode) {
        this(aDecoratee, -1, 4, TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, new CrcSegmentPackager(aCrcChecksumConcatenateMode), TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        this(aDecoratee, -1, 4, TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, new CrcSegmentPackager(aCrcChecksumConcatenateMode, aEndianess), aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        this(aDecoratee, -1, 4, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, new CrcSegmentPackager(aCrcChecksumConcatenateMode, aEndianess), aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        this(aDecoratee, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, new CrcSegmentPackager(aCrcChecksumConcatenateMode, aEndianess), aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm) {
        this(aDecoratee, -1, 4, TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, new CrcSegmentPackager(aCrcAlgorithm), TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, Endianess aEndianess) {
        this(aDecoratee, -1, 4, TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, new CrcSegmentPackager(aCrcAlgorithm, aEndianess), aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, Endianess aEndianess) {
        this(aDecoratee, -1, 4, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, new CrcSegmentPackager(aCrcAlgorithm, aEndianess), aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, Endianess aEndianess) {
        this(aDecoratee, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, new CrcSegmentPackager(aCrcAlgorithm, aEndianess), aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode) {
        this(aDecoratee, -1, 4, TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, new CrcSegmentPackager(aCrcAlgorithm, aCrcChecksumConcatenateMode), TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        this(aDecoratee, -1, 4, TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, new CrcSegmentPackager(aCrcAlgorithm, aCrcChecksumConcatenateMode, aEndianess), aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        this(aDecoratee, -1, 4, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, (SegmentPackager)null, aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, Endianess aEndianess) {
        this(aDecoratee, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, new CrcSegmentPackager(aCrcAlgorithm, aCrcChecksumConcatenateMode, aEndianess), aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode) {
        this(aDecoratee, -1, 4, TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_MAGIC_BYTES, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_RETRY_NUMBER, TransmissionMetrics.DEFAULT_ACKNOWLEDGE_TIMEOUT_IN_MS, new CrcSegmentPackager(aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode), TransmissionMetrics.DEFAULT_ENDIANESS);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        this(aDecoratee, -1, 4, TransmissionMetrics.DEFAULT_SEQUENCE_NUMBER_CONCATENATE_MODE, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, new CrcSegmentPackager(aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode, aEndianess), aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        this(aDecoratee, -1, 4, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, new CrcSegmentPackager(aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode, aEndianess), aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, CrcAlgorithm aCrcAlgorithm, ConcatenateMode aCrcChecksumConcatenateMode, ChecksumValidationMode aChecksumValidationMode, Endianess aEndianess) {
        this(aDecoratee, aSequenceNumberInitValue, aSequenceNumberWidth, aSequenceNumberConcatenateMode, aAcknowledgeMagicBytes, aAckRetryNumber, aAckTimeoutInMs, new CrcSegmentPackager(aCrcAlgorithm, aCrcChecksumConcatenateMode, aChecksumValidationMode, aEndianess), aEndianess);
    }

    public AbstractStopAndWaitTransmissionDecorator(DECORATEE aDecoratee, int aSequenceNumberInitValue, int aSequenceNumberWidth, ConcatenateMode aSequenceNumberConcatenateMode, byte[] aAcknowledgeMagicBytes, int aAckRetryNumber, long aAckTimeoutInMs, SegmentPackager aAckSegmentPackager, Endianess aEndianess) {
        super(aDecoratee, aAckRetryNumber, aAckTimeoutInMs);
        this._acknowledgeMagicBytes = aAcknowledgeMagicBytes;
        this._acknowledgeSegmentPackager = aAckSegmentPackager;
        this._sequenceNumberInitValue = aSequenceNumberInitValue;
        this._sequenceNumber = aSequenceNumberInitValue != -1 ? aSequenceNumberInitValue : 0;
        this._sequenceNumberWidth = aSequenceNumberWidth;
        this._sequenceNumberConcatenateMode = aSequenceNumberConcatenateMode;
        this._endianess = aEndianess;
        this._acknowledgeSegmentPackager = aAckSegmentPackager != null ? aAckSegmentPackager : new SegmentPackager.DummySegmentPackager();
        Segment[] segmentArray = new Segment.SegmentMixin[2];
        this._acknowledgeMagicBytesSegment = new MagicBytesSegment(this._acknowledgeMagicBytes);
        segmentArray[0] = this._acknowledgeMagicBytesSegment;
        this._acknowledgeSequenceNumberSegment = new NumberSegment(this._sequenceNumberWidth, this._endianess);
        segmentArray[1] = this._acknowledgeSequenceNumberSegment;
        this._acknowledgeSegment = this._acknowledgeSegmentPackager.toPackaged(new SegmentComposite(segmentArray));
    }

    @Override
    public void transmitTo(OutputStream aOutputStream, InputStream aReturnStream) throws IOException {
        if (aReturnStream != null) {
            byte[] theSequenceBytes = this._endianess.toUnsignedBytes((long)this._sequenceNumber, this._sequenceNumberWidth);
            Exception eException = null;
            RetryCounter theRetries = new RetryCounter(this.getAcknowledgeRetryNumber(), this.getAcknowledgeTimeoutMillis());
            TimeoutInputStream theTimeoutInputStream = SerialUtility.createTimeoutInputStream(aReturnStream, this._acknowledgeTimeoutInMs);
            SkipAvailableInputStream theSkipReturnStream = new SkipAvailableInputStream(aReturnStream, this._acknowledgeTimeoutInMs);
            while (theRetries.nextRetry()) {
                eException = null;
                try {
                    switch (this._sequenceNumberConcatenateMode) {
                        case APPEND: {
                            this._decoratee.transmitTo(aOutputStream, aReturnStream);
                            aOutputStream.write(theSequenceBytes);
                            break;
                        }
                        case PREPEND: {
                            aOutputStream.write(theSequenceBytes);
                            this._decoratee.transmitTo(aOutputStream, aReturnStream);
                            break;
                        }
                        default: {
                            throw new BugException("The value <" + this._sequenceNumberConcatenateMode + "> of enumeration <" + ConcatenateMode.class.getName() + "> has been forgotten to implement!");
                        }
                    }
                    this._acknowledgeSegment.receiveFrom((InputStream)theTimeoutInputStream);
                    byte[] eAck = this._acknowledgeMagicBytesSegment.getPayload();
                    int eSequenceNumber = ((Long)this._acknowledgeSequenceNumberSegment.getPayload()).intValue();
                    if (Arrays.equals(eAck, this._acknowledgeMagicBytes) && eSequenceNumber == this._sequenceNumber) {
                        ++this._sequenceNumber;
                        return;
                    }
                }
                catch (Exception e) {
                    eException = e;
                }
                if (!theRetries.hasNextRetry()) continue;
                try {
                    theSkipReturnStream.skipAvailableWithin(IoTimeout.toTimeoutSleepLoopTimeInMs((long)this._acknowledgeTimeoutInMs));
                }
                catch (IOException iOException) {}
            }
            if (eException != null) {
                throw new FlowControlRetryException(this._acknowledgeRetryNumber, this._acknowledgeTimeoutInMs, "Aborting after <" + this.getAcknowledgeRetryNumber() + "> retries with a timeout for each retry of <" + this.getAcknowledgeTimeoutMillis() + "> milliseconds: " + eException.getMessage(), eException);
            }
            throw new FlowControlRetryException(this._acknowledgeRetryNumber, this._acknowledgeTimeoutInMs, "Aborting after <" + this.getAcknowledgeRetryNumber() + "> retries with a timeout for each retry of <" + this.getAcknowledgeTimeoutMillis() + "> milliseconds.");
        }
        this._decoratee.transmitTo(aOutputStream, aReturnStream);
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getClass(), this.toSequence(), this.getLength(), "A segment decorator enriching the encapsulated segment with \"Stop-and-wait ARQ\".", new Schema[]{this.getDecoratee().toSchema()});
        theSchema.put("ACK_RETRY_NUMBER", this.getAcknowledgeRetryNumber());
        theSchema.put("ACK_TIMEOUT_IN_MS", this.getAcknowledgeTimeoutMillis());
        theSchema.put(ACK_MAGIC_BYTES, this.getAcknowledgeMagicBytes());
        return theSchema;
    }

    @Override
    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    @Override
    public int getAcknowledgeRetryNumber() {
        return this._acknowledgeRetryNumber;
    }

    @Override
    public long getAcknowledgeTimeoutMillis() {
        return this._acknowledgeTimeoutInMs;
    }

    @Override
    public byte[] getAcknowledgeMagicBytes() {
        return this._acknowledgeMagicBytes;
    }

    @Override
    public SegmentPackager getAcknowledgeSegmentPackager() {
        return this._acknowledgeSegmentPackager;
    }

    @Override
    public int getLength() {
        return this._decoratee.getLength();
    }

    @Override
    public Sequence toSequence() {
        return this._decoratee.toSequence();
    }

    @Override
    public DECORATEE getDecoratee() {
        return (DECORATEE)this._decoratee;
    }

    public Endianess getEndianess() {
        return this._endianess;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [segment=" + this._decoratee + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._decoratee == null ? 0 : this._decoratee.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractStopAndWaitTransmissionDecorator other = (AbstractStopAndWaitTransmissionDecorator)obj;
        return !(this._decoratee == null ? other._decoratee != null : !this._decoratee.equals(other._decoratee));
    }

    @Override
    public SimpleTypeMap toSimpleTypeMap() {
        return this._decoratee != null ? this._decoratee.toSimpleTypeMap() : new SimpleTypeMapImpl();
    }

    protected long readSequenceNumber(InputStream aInputStream) throws IOException {
        byte[] theSequenceBytes = new byte[this._sequenceNumberWidth];
        int theLength = aInputStream.read(theSequenceBytes, 0, theSequenceBytes.length);
        if (theLength != theSequenceBytes.length) {
            throw new FlowControlException("While reading the sequence number, unexpected number of bytes received <" + theLength + "> of the number of bytes expected <" + theSequenceBytes.length + ">.");
        }
        return this._endianess.toLong(theSequenceBytes);
    }
}

