/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.refcodes.io.BoundedInputStream;
import org.refcodes.mixin.Schema;
import org.refcodes.serial.AbstractTransmissionDecorator;
import org.refcodes.serial.AllocLengthAccessor;
import org.refcodes.serial.Section;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;

public class AllocSegmentBody<DECORATEE extends Section>
extends AbstractTransmissionDecorator<DECORATEE>
implements Segment,
AllocLengthAccessor.AllocLengthProperty {
    private static final long serialVersionUID = 1L;
    private int _value;

    public AllocSegmentBody(DECORATEE aDecoratee) {
        super(aDecoratee);
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws TransmissionException {
        if (this._value > 0) {
            ((Section)this._decoratee).fromTransmission(aSequence, aOffset, this._value);
        }
        return aOffset + this._value;
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException, TransmissionException {
        if (this._value > 0) {
            ((Section)this._decoratee).receiveFrom((InputStream)new BoundedInputStream(aInputStream, this._value), this._value, aReturnStream);
        }
    }

    @Override
    public int getAllocLength() {
        return this._value;
    }

    @Override
    public void setAllocLength(int aValue) {
        this._value = aValue;
    }

    @Override
    public SerialSchema toSchema() {
        return new SerialSchema(this.getClass(), this.toSequence(), this.getLength(), "An allocation decorator body referencing a decoratee and managing the length of the decoratee (provided by the according head) in bytes.", new Schema[]{this._decoratee != null ? ((Section)this._decoratee).toSchema() : null});
    }
}

