/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.refcodes.mixin.Schema;
import org.refcodes.serial.BadMagicBytesException;
import org.refcodes.serial.BadMagicBytesSequenceException;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.MagicBytesSegmentDecorator;
import org.refcodes.serial.Segment;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.textual.VerboseTextBuilder;

public class AssertMagicBytesSegmentDecorator<DECORATEE extends Segment>
extends MagicBytesSegmentDecorator<DECORATEE> {
    private static final long serialVersionUID = 1L;

    public AssertMagicBytesSegmentDecorator(DECORATEE aDecoratee, byte ... aMagicBytes) {
        super(aDecoratee, aMagicBytes);
    }

    public AssertMagicBytesSegmentDecorator(DECORATEE aDecoratee, String aMagicBytes, Charset aCharset) {
        super(aDecoratee, aMagicBytes, aCharset);
    }

    public AssertMagicBytesSegmentDecorator(DECORATEE aDecoratee, String aMagicBytes) {
        super(aDecoratee, aMagicBytes);
    }

    public AssertMagicBytesSegmentDecorator(String aAlias, DECORATEE aDecoratee, byte ... aMagicBytes) {
        super(aAlias, aDecoratee, aMagicBytes);
    }

    public AssertMagicBytesSegmentDecorator(String aAlias, DECORATEE aDecoratee, String aMagicBytes, Charset aCharset) {
        super(aAlias, aDecoratee, aMagicBytes, aCharset);
    }

    public AssertMagicBytesSegmentDecorator(String aAlias, DECORATEE aDecoratee, String aMagicBytes) {
        super(aAlias, aDecoratee, aMagicBytes);
    }

    @Override
    public int fromTransmission(Sequence aSequence, int aOffset) throws BadMagicBytesSequenceException, TransmissionException {
        byte[] theMagicBytes = aSequence.toBytes(aOffset, this._magicBytesLength);
        if (!Arrays.equals(this._magicBytes, theMagicBytes)) {
            throw new BadMagicBytesSequenceException(theMagicBytes, aSequence, "The received magic bytes " + VerboseTextBuilder.asString((byte[])theMagicBytes) + " do not match the expected magic bytes " + VerboseTextBuilder.asString((byte[])this._magicBytes) + "!");
        }
        return ((Segment)this.getDecoratee()).fromTransmission(aSequence, aOffset + this._magicBytesLength);
    }

    @Override
    public void receiveFrom(InputStream aInputStream, OutputStream aReturnStream) throws IOException, TransmissionException {
        byte[] theMagicBytes = new byte[this._magicBytesLength];
        for (int i = 0; i < this._magicBytesLength; ++i) {
            aInputStream.read(theMagicBytes, i, 1);
            if (this._magicBytes[i] == theMagicBytes[i]) continue;
            theMagicBytes = new ByteArraySequence(theMagicBytes, 0, i + 1).toBytes();
            throw new BadMagicBytesException(theMagicBytes, "The received magic bytes " + VerboseTextBuilder.asString((byte[])theMagicBytes) + " do not match the expected magic bytes " + VerboseTextBuilder.asString((byte[])this._magicBytes) + "!");
        }
        ((Segment)this.getDecoratee()).receiveFrom(aInputStream, aReturnStream);
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getAlias(), this.getClass(), this.toSequence(), this.getLength(), "A segment decorator asserting and prefixing the encapsulated segment with configured magic bytes.", new Schema[0]);
        theSchema.put("MAGIC_BYTES", this.getMagicBytes());
        theSchema.put("MAGIC_BYTES_TEXT", this.toMagicBytesString());
        return theSchema;
    }
}

