/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.nio.charset.Charset;
import org.refcodes.mixin.EncodingAccessor;
import org.refcodes.mixin.Schema;
import org.refcodes.serial.AbstractPayloadSection;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.Section;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.TransmissionSequenceException;
import org.refcodes.textual.CaseStyleBuilder;

public class CharSection
extends AbstractPayloadSection<Character>
implements Section,
EncodingAccessor<Charset> {
    private static final long serialVersionUID = 1L;
    private String _charset = TransmissionMetrics.DEFAULT_ENCODING.name();

    public CharSection(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEncoding());
    }

    public CharSection(char aValue, TransmissionMetrics aTransmissionMetrics) {
        this(Character.valueOf(aValue), aTransmissionMetrics.getEncoding());
    }

    public CharSection(Character aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aValue, aTransmissionMetrics.getEncoding());
    }

    public CharSection(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getEncoding());
    }

    public CharSection(String aAlias, char aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, Character.valueOf(aValue), aTransmissionMetrics.getEncoding());
    }

    public CharSection(String aAlias, Character aValue, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aValue, aTransmissionMetrics.getEncoding());
    }

    public CharSection() {
        this(CaseStyleBuilder.asCamelCase((String)CharSection.class.getSimpleName()));
    }

    public CharSection(Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase((String)CharSection.class.getSimpleName()), aCharset);
    }

    public CharSection(Character aPayload) {
        this(CaseStyleBuilder.asCamelCase((String)CharSection.class.getSimpleName()), aPayload);
    }

    public CharSection(Character aPayload, Charset aCharset) {
        this(CaseStyleBuilder.asCamelCase((String)CharSection.class.getSimpleName()), aPayload, aCharset);
    }

    public CharSection(String aAlias) {
        this(aAlias, Character.valueOf('\u0000'), TransmissionMetrics.DEFAULT_ENCODING);
    }

    public CharSection(String aAlias, Charset aCharset) {
        this(aAlias, Character.valueOf('\u0000'), aCharset);
    }

    public CharSection(String aAlias, Character aPayload) {
        this(aAlias, aPayload, TransmissionMetrics.DEFAULT_ENCODING);
    }

    public CharSection(String aAlias, Character aPayload, Charset aCharset) {
        super(aAlias, aPayload);
        this._charset = aCharset != null ? aCharset.name() : TransmissionMetrics.DEFAULT_ENCODING.name();
    }

    @Override
    public Sequence toSequence() {
        return new ByteArraySequence(Character.toString(((Character)this.getPayload()).charValue()).getBytes(this.getEncoding()));
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        byte[] theRecord = aSequence.toBytes(aOffset, aLength);
        String theTemp = new String(theRecord, this.getEncoding());
        if (theTemp.length() != 1) {
            throw new TransmissionSequenceException(aSequence, "The sequence with length <" + aLength + "> at the offset <" + aOffset + "> results in <" + theTemp + ">, though a single character is expected!");
        }
        this.setPayload(Character.valueOf(theTemp.charAt(0)));
    }

    @Override
    public int getLength() {
        return this.toSequence().getLength();
    }

    @Override
    public SerialSchema toSchema() {
        return new SerialSchema(this.getAlias(), this.getClass(), this.toSequence(), this.getLength(), "" + this.getPayload(), "A body containing an byte payload.", new Schema[0]);
    }

    public CharSection withPayload(Character aValue) {
        this.setPayload(aValue);
        return this;
    }

    public Charset getEncoding() {
        return this._charset != null ? Charset.forName(this._charset) : TransmissionMetrics.DEFAULT_ENCODING;
    }
}

