/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.refcodes.serial.AbstractCipherTransmissionDecorator;
import org.refcodes.serial.Section;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SequenceInputStream;
import org.refcodes.serial.TransmissionException;

public class CipherSectionDecorator<DECORATEE extends Section>
extends AbstractCipherTransmissionDecorator<DECORATEE>
implements Section {
    private static final long serialVersionUID = 1L;

    public CipherSectionDecorator(DECORATEE aDecoratee, Cipher aCipher) {
        super(aDecoratee, aCipher);
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        SequenceInputStream theSequenceInputStream = new SequenceInputStream(aSequence, aOffset);
        try {
            this.receiveFrom(theSequenceInputStream, aLength, null);
        }
        catch (IOException e) {
            throw new TransmissionException(e.getMessage(), e);
        }
        if (aLength + aOffset != theSequenceInputStream.getOffset()) {
            throw new TransmissionException("The number of bytes <" + aLength + "> to be read at offset <" + aOffset + "> from the sequence is exceeded by the actual number of bytes read <" + (theSequenceInputStream.getOffset() - aOffset) + ">!");
        }
    }

    @Override
    public void receiveFrom(InputStream aInputStream, int aLength, OutputStream aReturnStream) throws IOException, TransmissionException {
        CipherInputStream theCipherInputStream = new CipherInputStream(aInputStream, this._cipher);
        CipherOutputStream theCipherReturnStream = aReturnStream != null ? new CipherOutputStream(aReturnStream, this._cipher) : null;
        ((Section)this._decoratee).receiveFrom(theCipherInputStream, aLength, theCipherReturnStream);
    }
}

