/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.serial;

import java.util.Arrays;
import org.refcodes.mixin.Schema;
import org.refcodes.numerical.Endianess;
import org.refcodes.serial.AbstractPayloadSection;
import org.refcodes.serial.ByteArraySequence;
import org.refcodes.serial.PayloadSection;
import org.refcodes.serial.Sequence;
import org.refcodes.serial.SerialSchema;
import org.refcodes.serial.TransmissionException;
import org.refcodes.serial.TransmissionMetrics;
import org.refcodes.serial.TransmissionSequenceException;
import org.refcodes.textual.CaseStyleBuilder;

public class DoubleArraySection
extends AbstractPayloadSection<double[]>
implements PayloadSection<double[]> {
    private static final long serialVersionUID = 1L;
    public static final String ENDIANESS = "ENDIANESS";
    private Endianess _endianess;

    public DoubleArraySection(TransmissionMetrics aTransmissionMetrics) {
        this(aTransmissionMetrics.getEndianess());
    }

    public DoubleArraySection(TransmissionMetrics aTransmissionMetrics, double ... aValue) {
        this(aTransmissionMetrics.getEndianess(), aValue);
    }

    public DoubleArraySection(TransmissionMetrics aTransmissionMetrics, Double ... aValue) {
        this(aTransmissionMetrics.getEndianess(), aValue);
    }

    public DoubleArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics) {
        this(aAlias, aTransmissionMetrics.getEndianess());
    }

    public DoubleArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics, double ... aValue) {
        this(aAlias, aTransmissionMetrics.getEndianess(), aValue);
    }

    public DoubleArraySection(String aAlias, TransmissionMetrics aTransmissionMetrics, Double ... aValue) {
        this(aAlias, aTransmissionMetrics.getEndianess(), aValue);
    }

    public DoubleArraySection() {
        this(CaseStyleBuilder.asCamelCase((String)DoubleArraySection.class.getSimpleName()), new double[0]);
    }

    public DoubleArraySection(Endianess aEndianess) {
        this(CaseStyleBuilder.asCamelCase((String)DoubleArraySection.class.getSimpleName()), aEndianess, new double[0]);
    }

    public DoubleArraySection(double ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)DoubleArraySection.class.getSimpleName()), aValue);
    }

    public DoubleArraySection(Double ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)DoubleArraySection.class.getSimpleName()), aValue);
    }

    public DoubleArraySection(Endianess aEndianess, double ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)DoubleArraySection.class.getSimpleName()), aEndianess, aValue);
    }

    public DoubleArraySection(Endianess aEndianess, Double ... aValue) {
        this(CaseStyleBuilder.asCamelCase((String)DoubleArraySection.class.getSimpleName()), aEndianess, DoubleArraySection.toPrimitiveArray(aValue));
    }

    public DoubleArraySection(String aAlias) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, new double[0]);
    }

    public DoubleArraySection(String aAlias, Endianess aEndianess) {
        this(aAlias, aEndianess, new double[0]);
    }

    public DoubleArraySection(String aAlias, double ... aValue) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, aValue);
    }

    public DoubleArraySection(String aAlias, Double ... aValue) {
        this(aAlias, TransmissionMetrics.DEFAULT_ENDIANESS, aValue);
    }

    public DoubleArraySection(String aAlias, Endianess aEndianess, double ... aValue) {
        super(aAlias, aValue);
        this._endianess = aEndianess;
    }

    public DoubleArraySection(String aAlias, Endianess aEndianess, Double ... aValue) {
        super(aAlias, DoubleArraySection.toPrimitiveArray(aValue));
        this._endianess = aEndianess;
    }

    @Override
    public Sequence toSequence() {
        byte[] theBytes = new byte[((double[])this.getPayload()).length * 8];
        for (int i = 0; i < ((double[])this.getPayload()).length; ++i) {
            byte[] eRecord = this._endianess.toBytes(((double[])this.getPayload())[i]);
            for (int j = 0; j < eRecord.length; ++j) {
                theBytes[i * 8 + j] = eRecord[j];
            }
        }
        return new ByteArraySequence(theBytes);
    }

    @Override
    public void fromTransmission(Sequence aSequence, int aOffset, int aLength) throws TransmissionException {
        if (aLength % 8 != 0) {
            throw new TransmissionSequenceException(aSequence, "The length dedicated <" + aLength + "> does not match a multiple double length <8> for retrieving an double array from the given sequence at the offset <" + aOffset + ">!");
        }
        double[] theValues = new double[aLength / 8];
        for (int i = 0; i < theValues.length; ++i) {
            byte[] eRecord = aSequence.toBytes(aOffset + i * 8, 8);
            theValues[i] = this._endianess.toDouble(eRecord);
        }
        this.setPayload(theValues);
    }

    @Override
    public int getLength() {
        return this.getPayload() != null ? ((double[])this.getPayload()).length * 8 : 0;
    }

    @Override
    public SerialSchema toSchema() {
        SerialSchema theSchema = new SerialSchema(this.getAlias(), this.getClass(), this.toSequence(), this.getLength(), "A body containing an double payload.", new Schema[0]);
        theSchema.put(ENDIANESS, this._endianess);
        return theSchema;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", value=" + Arrays.toString((double[])this.getPayload()) + "]";
    }

    public DoubleArraySection withPayload(double[] aValue) {
        this.setPayload(aValue);
        return this;
    }

    @Override
    public void setPayload(Double[] aPayload) {
        this.setPayload(DoubleArraySection.toPrimitiveArray(aPayload));
    }

    public DoubleArraySection withPayload(Double[] aPayload) {
        this.setPayload(DoubleArraySection.toPrimitiveArray(aPayload));
        return this;
    }

    private static double[] toPrimitiveArray(Double[] aValue) {
        double[] theResult = new double[aValue.length];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = aValue[i];
        }
        return theResult;
    }
}

